/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature.formatter;

import java.util.ArrayList;
import net.entropysoft.transmorph.signature.ArrayTypeSignature;
import net.entropysoft.transmorph.signature.ClassTypeSignature;
import net.entropysoft.transmorph.signature.PrimitiveTypeSignature;
import net.entropysoft.transmorph.signature.TypeArgSignature;
import net.entropysoft.transmorph.signature.TypeSignature;
import net.entropysoft.transmorph.signature.TypeVarSignature;
import net.entropysoft.transmorph.signature.formatter.ITypeSignatureFormatter;

public class ClassFileTypeSignatureFormatter
implements ITypeSignatureFormatter {
    private char packageSeparator = (char)47;
    private char innerClassPrefix = (char)46;

    public ClassFileTypeSignatureFormatter() {
    }

    public ClassFileTypeSignatureFormatter(boolean useInternalFormFullyQualifiedName) {
        this.setUseInternalFormFullyQualifiedName(useInternalFormFullyQualifiedName);
    }

    public void setUseInternalFormFullyQualifiedName(boolean value) {
        if (value) {
            this.packageSeparator = (char)47;
            this.innerClassPrefix = (char)46;
        } else {
            this.packageSeparator = (char)46;
            this.innerClassPrefix = (char)36;
        }
    }

    public String format(TypeSignature typeSignature) {
        if (typeSignature.isPrimitiveType()) {
            return this.formatPrimitiveTypeSignature((PrimitiveTypeSignature)typeSignature);
        }
        if (typeSignature.isArrayType()) {
            return this.formatArrayTypeSignature((ArrayTypeSignature)typeSignature);
        }
        if (typeSignature.isClassType()) {
            return this.formatClassTypeSignature((ClassTypeSignature)typeSignature);
        }
        if (typeSignature.isTypeVar()) {
            return this.formatTypeVarSignature((TypeVarSignature)typeSignature);
        }
        if (typeSignature.isTypeArgument()) {
            return this.formatTypeArgSignature((TypeArgSignature)typeSignature);
        }
        return null;
    }

    private String formatArrayTypeSignature(ArrayTypeSignature typeSignature) {
        return '[' + this.format(typeSignature.getComponentTypeSignature());
    }

    private String formatPrimitiveTypeSignature(PrimitiveTypeSignature primitiveTypeSignature) {
        return new String(new char[]{primitiveTypeSignature.getPrimitiveTypeChar()});
    }

    private ClassTypeSignature[] getClassTypeSignatures(ClassTypeSignature classTypeSignature) {
        ArrayList<ClassTypeSignature> list = new ArrayList<ClassTypeSignature>();
        while (classTypeSignature != null) {
            list.add(0, classTypeSignature);
            classTypeSignature = classTypeSignature.getOwnerTypeSignature();
        }
        return list.toArray(new ClassTypeSignature[list.size()]);
    }

    private String formatClassTypeSignature(ClassTypeSignature typeSignature) {
        ClassTypeSignature[] classTypeSignatures = this.getClassTypeSignatures(typeSignature);
        StringBuilder sb = new StringBuilder();
        sb.append('L');
        for (int i = 0; i < classTypeSignatures.length; ++i) {
            ClassTypeSignature classTypeSignature = classTypeSignatures[i];
            if (i == 0) {
                sb.append(classTypeSignature.getBinaryName().replace('.', this.packageSeparator));
            } else {
                sb.append(this.innerClassPrefix);
                sb.append(classTypeSignature.getBinaryName());
            }
            if (classTypeSignature.getTypeArgSignatures().length <= 0) continue;
            sb.append('<');
            for (TypeArgSignature typeArgSignature : classTypeSignature.getTypeArgSignatures()) {
                sb.append(this.formatTypeArgSignature(typeArgSignature));
            }
            sb.append('>');
        }
        sb.append(';');
        return sb.toString();
    }

    public String formatTypeVarSignature(TypeVarSignature typeSignature) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('T');
        stringBuilder.append(typeSignature.getId());
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    public String formatTypeArgSignature(TypeArgSignature typeArgSignature) {
        StringBuilder sb = new StringBuilder();
        char wildcard = typeArgSignature.getWildcard();
        if (wildcard != TypeArgSignature.NO_WILDCARD) {
            sb.append(wildcard);
        }
        if (typeArgSignature.getFieldTypeSignature() != null) {
            sb.append(this.format(typeArgSignature.getFieldTypeSignature()));
        }
        return sb.toString();
    }
}

