/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature;

import net.entropysoft.transmorph.signature.FullTypeSignature;

public class PrimitiveTypeSignature
extends FullTypeSignature {
    public static final char PRIMITIVE_BOOLEAN = 'Z';
    public static final char PRIMITIVE_BYTE = 'B';
    public static final char PRIMITIVE_CHAR = 'C';
    public static final char PRIMITIVE_DOUBLE = 'D';
    public static final char PRIMITIVE_FLOAT = 'F';
    public static final char PRIMITIVE_INT = 'I';
    public static final char PRIMITIVE_LONG = 'J';
    public static final char PRIMITIVE_SHORT = 'S';
    private final char primitiveChar;

    public PrimitiveTypeSignature(char primitiveChar) {
        this.primitiveChar = primitiveChar;
    }

    public char getPrimitiveTypeChar() {
        return this.primitiveChar;
    }

    public String toString() {
        return this.getSignature();
    }

    public boolean isPrimitiveType() {
        return true;
    }

    public boolean isBoolean() {
        return this.primitiveChar == 'Z';
    }

    public boolean isByte() {
        return this.primitiveChar == 'B';
    }

    public boolean isChar() {
        return this.primitiveChar == 'C';
    }

    public boolean isDouble() {
        return this.primitiveChar == 'D';
    }

    public boolean isFloat() {
        return this.primitiveChar == 'F';
    }

    public boolean isInt() {
        return this.primitiveChar == 'I';
    }

    public boolean isLong() {
        return this.primitiveChar == 'J';
    }

    public boolean isShort() {
        return this.primitiveChar == 'S';
    }

    public boolean isNumber() {
        return this.primitiveChar == 'D' || this.primitiveChar == 'F' || this.primitiveChar == 'I' || this.primitiveChar == 'J' || this.primitiveChar == 'S' || this.primitiveChar == 'B';
    }

    public FullTypeSignature getTypeErasureSignature() {
        return this;
    }
}

