/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.signature.ArrayTypeSignature;
import net.entropysoft.transmorph.signature.ClassTypeSignature;
import net.entropysoft.transmorph.signature.FieldTypeSignature;
import net.entropysoft.transmorph.signature.FullTypeSignature;
import net.entropysoft.transmorph.signature.TypeArgSignature;
import net.entropysoft.transmorph.signature.TypeSignature;
import net.entropysoft.transmorph.signature.TypeSignatureFactory;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeToTypeSignature {
    private static Map<Class<?>, Character> primitiveTypesMap = new HashMap();

    private ArrayTypeSignature getArrayTypeSignature(GenericArrayType genericArrayType) {
        FullTypeSignature componentTypeSignature = this.getFullTypeSignature(genericArrayType.getGenericComponentType());
        ArrayTypeSignature arrayTypeSignature = new ArrayTypeSignature(componentTypeSignature);
        return arrayTypeSignature;
    }

    private ClassTypeSignature getClassTypeSignature(ParameterizedType parameterizedType) {
        Class rawType = (Class)parameterizedType.getRawType();
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        TypeArgSignature[] typeArgSignatures = new TypeArgSignature[typeArguments.length];
        for (int i = 0; i < typeArguments.length; ++i) {
            typeArgSignatures[i] = this.getTypeArgSignature(typeArguments[i]);
        }
        String binaryName = rawType.isMemberClass() ? rawType.getSimpleName() : rawType.getName();
        ClassTypeSignature ownerTypeSignature = parameterizedType.getOwnerType() == null ? null : (ClassTypeSignature)this.getFullTypeSignature(parameterizedType.getOwnerType());
        ClassTypeSignature classTypeSignature = new ClassTypeSignature(binaryName, typeArgSignatures, ownerTypeSignature);
        return classTypeSignature;
    }

    public TypeSignature getTypeSignature(Type type) {
        FullTypeSignature typeSignature = this.getFullTypeSignature(type);
        if (typeSignature != null) {
            return typeSignature;
        }
        if (type instanceof WildcardType) {
            return this.getTypeArgSignature((WildcardType)type);
        }
        return null;
    }

    public TypeSignature getTypeSignature(TypeReference<?> type) {
        return this.getTypeSignature(type.getType());
    }

    private FullTypeSignature getFullTypeSignature(Type type) {
        if (type instanceof Class) {
            return this.getTypeSignature((Class)type);
        }
        if (type instanceof GenericArrayType) {
            return this.getArrayTypeSignature((GenericArrayType)type);
        }
        if (type instanceof ParameterizedType) {
            return this.getClassTypeSignature((ParameterizedType)type);
        }
        return null;
    }

    private FullTypeSignature getTypeSignature(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        if (clazz.isArray()) {
            sb.append(clazz.getName());
        } else if (clazz.isPrimitive()) {
            sb.append(primitiveTypesMap.get(clazz).toString());
        } else {
            sb.append('L').append(clazz.getName()).append(';');
        }
        return TypeSignatureFactory.getTypeSignature(sb.toString(), false);
    }

    private TypeArgSignature getTypeArgSignature(Type type) {
        if (type instanceof WildcardType) {
            Type upperBound;
            WildcardType wildcardType = (WildcardType)type;
            Type lowerBound = wildcardType.getLowerBounds().length == 0 ? null : wildcardType.getLowerBounds()[0];
            Type type2 = upperBound = wildcardType.getUpperBounds().length == 0 ? null : wildcardType.getUpperBounds()[0];
            if (lowerBound == null && Object.class.equals((Object)upperBound)) {
                return new TypeArgSignature(TypeArgSignature.UNBOUNDED_WILDCARD, (FieldTypeSignature)this.getFullTypeSignature(upperBound));
            }
            if (lowerBound == null && upperBound != null) {
                return new TypeArgSignature(TypeArgSignature.UPPERBOUND_WILDCARD, (FieldTypeSignature)this.getFullTypeSignature(upperBound));
            }
            if (lowerBound != null) {
                return new TypeArgSignature(TypeArgSignature.LOWERBOUND_WILDCARD, (FieldTypeSignature)this.getFullTypeSignature(lowerBound));
            }
            throw new RuntimeException("Invalid type");
        }
        return new TypeArgSignature(TypeArgSignature.NO_WILDCARD, (FieldTypeSignature)this.getFullTypeSignature(type));
    }

    static {
        primitiveTypesMap.put(Boolean.TYPE, Character.valueOf('Z'));
        primitiveTypesMap.put(Byte.TYPE, Character.valueOf('B'));
        primitiveTypesMap.put(Character.TYPE, Character.valueOf('C'));
        primitiveTypesMap.put(Double.TYPE, Character.valueOf('D'));
        primitiveTypesMap.put(Float.TYPE, Character.valueOf('F'));
        primitiveTypesMap.put(Integer.TYPE, Character.valueOf('I'));
        primitiveTypesMap.put(Long.TYPE, Character.valueOf('J'));
        primitiveTypesMap.put(Short.TYPE, Character.valueOf('S'));
    }
}

