/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.injectors;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Map;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.IdentityConverter;
import net.entropysoft.transmorph.converters.MultiConverter;
import net.entropysoft.transmorph.converters.WrapperToPrimitive;
import net.entropysoft.transmorph.converters.beans.IBeanPropertyTypeProvider;
import net.entropysoft.transmorph.injectors.AbstractBeanInjector;
import net.entropysoft.transmorph.type.TypeReference;
import net.entropysoft.transmorph.utils.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapToBeanInjector
extends AbstractBeanInjector {
    private IBeanPropertyTypeProvider beanDestinationPropertyTypeProvider;

    public MapToBeanInjector() {
        this.propertyValueConverter = new MultiConverter(new IdentityConverter(), new WrapperToPrimitive());
    }

    public void setBeanDestinationPropertyTypeProvider(IBeanPropertyTypeProvider beanDestinationPropertyTypeProvider) {
        this.beanDestinationPropertyTypeProvider = beanDestinationPropertyTypeProvider;
    }

    public IBeanPropertyTypeProvider getBeanDestinationPropertyTypeProvider() {
        return this.beanDestinationPropertyTypeProvider;
    }

    @Override
    public boolean canHandle(Object sourceObject, TypeReference<?> targetType) {
        if (!(sourceObject instanceof Map)) {
            return false;
        }
        for (Object object : ((Map)sourceObject).keySet()) {
            if (object instanceof String) continue;
            return false;
        }
        return true;
    }

    @Override
    public void inject(ConversionContext context, Object sourceObject, Object targetBean, TypeReference<?> targetType) throws ConverterException {
        Map sourceMap = (Map)sourceObject;
        Class<?> targetTypeClass = targetType.getRawType();
        Map<String, Method> setterMethods = BeanUtils.getSetters(targetTypeClass);
        for (Map.Entry entry : sourceMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Method method = setterMethods.get(key);
            if (method == null) {
                throw new ConverterException(MessageFormat.format("Could not find property ''{0}'' in ''{1}''", key, targetType.toHumanString()));
            }
            Type parameterType = method.getGenericParameterTypes()[0];
            TypeReference<?> originalType = TypeReference.get(parameterType);
            TypeReference<?> propertyDestinationType = this.getBeanPropertyType(targetTypeClass, key, originalType);
            Object valueConverted = this.propertyValueConverter.convert(context, value, propertyDestinationType);
            try {
                method.invoke(targetBean, valueConverted);
            }
            catch (Exception e) {
                throw new ConverterException("Could not set property for bean", e);
            }
        }
    }

    protected TypeReference<?> getBeanPropertyType(Class<?> targetClass, String propertyName, TypeReference<?> originalType) {
        TypeReference<?> propertyDestinationType = null;
        if (this.beanDestinationPropertyTypeProvider != null) {
            propertyDestinationType = this.beanDestinationPropertyTypeProvider.getPropertyType(targetClass, propertyName, originalType);
        }
        if (propertyDestinationType == null) {
            propertyDestinationType = originalType;
        }
        return propertyDestinationType;
    }
}

