/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.propertyeditors;

import java.beans.PropertyEditor;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractConverter;
import net.entropysoft.transmorph.converters.propertyeditors.DefaultPropertyEditorProvider;
import net.entropysoft.transmorph.converters.propertyeditors.IPropertyEditorProvider;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromStringUsingPropertyEditor
extends AbstractConverter {
    private IPropertyEditorProvider propertyEditorProvider = new DefaultPropertyEditorProvider();

    public IPropertyEditorProvider getPropertyEditorProvider() {
        return this.propertyEditorProvider;
    }

    public void setPropertyEditorProvider(IPropertyEditorProvider propertyEditorProvider) {
        this.propertyEditorProvider = propertyEditorProvider;
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return this.propertyEditorProvider.getPropertyEditor(destinationType.getRawType()) != null;
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject instanceof String;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            if (destinationType.isPrimitive()) {
                throw new ConverterException("Could not convert null to primitive type");
            }
            return null;
        }
        PropertyEditor propertyEditor = this.propertyEditorProvider.getPropertyEditor(destinationType.getRawType());
        String text = (String)sourceObject;
        propertyEditor.setAsText(text);
        return propertyEditor.getValue();
    }
}

