/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.enums;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumToEnum
extends AbstractConverter {
    private Map<Enum, Map<Class<? extends Enum>, Enum>> enumToEnumMap = new HashMap<Enum, Map<Class<? extends Enum>, Enum>>();

    public EnumToEnum() {
        this.useObjectPool = true;
    }

    public void addEnumToEnum(Enum<?> source, Enum<?> dest) {
        Map<Class<? extends Enum>, Enum> mapDestEnum = this.enumToEnumMap.get(source);
        if (mapDestEnum == null) {
            mapDestEnum = new HashMap<Class<? extends Enum>, Enum>();
            this.enumToEnumMap.put(source, mapDestEnum);
        }
        mapDestEnum.put(dest.getClass(), dest);
    }

    public void addEnumToNull(Enum<?> source, Class<? extends Enum> enumClass) {
        Map<Class<? extends Enum>, Enum> mapDestEnum = this.enumToEnumMap.get(source);
        if (mapDestEnum == null) {
            mapDestEnum = new HashMap<Class<? extends Enum>, Enum>();
            this.enumToEnumMap.put(source, mapDestEnum);
        }
        mapDestEnum.put(enumClass, null);
    }

    private Enum<?> getDestinationEnum(Enum<?> source, TypeReference<?> destinationType) throws ClassNotFoundException, ConverterException {
        Map<Class<? extends Enum>, Enum> mapDestEnum = this.enumToEnumMap.get(source);
        if (mapDestEnum != null && mapDestEnum.containsKey(destinationType.getType())) {
            Enum destEnum = mapDestEnum.get(destinationType.getType());
            return destEnum;
        }
        try {
            return Enum.valueOf(destinationType.getRawType(), source.name());
        }
        catch (IllegalArgumentException e) {
            throw new ConverterException(MessageFormat.format("Enum type ''{0}'' has no constant with the specified name ''{1}''", destinationType.toHumanString(), source.name()), e);
        }
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            return null;
        }
        Enum sourceEnum = (Enum)sourceObject;
        try {
            return this.getDestinationEnum(sourceEnum, destinationType);
        }
        catch (ClassNotFoundException e) {
            throw new ConverterException(MessageFormat.format("Could not find class for ''{0}''", destinationType.toHumanString()));
        }
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.getRawType().isEnum();
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject.getClass().isEnum();
    }
}

