/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.collections;

import java.lang.reflect.Type;
import java.util.Collection;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.converters.collections.DefaultStringArrayFormatter;
import net.entropysoft.transmorph.converters.collections.IStringArrayFormatter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionToString
extends AbstractContainerConverter {
    private IStringArrayFormatter stringArrayFormatter = new DefaultStringArrayFormatter();

    public CollectionToString() {
        this.useObjectPool = false;
    }

    public IStringArrayFormatter getStringArrayFormatter() {
        return this.stringArrayFormatter;
    }

    public void setStringArrayFormatter(IStringArrayFormatter stringArrayFormatter) {
        this.stringArrayFormatter = stringArrayFormatter;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            return null;
        }
        Collection collection = (Collection)sourceObject;
        String[] stringArray = new String[collection.size()];
        int i = 0;
        for (Object element : collection) {
            String elementConverted;
            stringArray[i] = elementConverted = (String)this.elementConverter.convert(context, element, destinationType);
            ++i;
        }
        return this.stringArrayFormatter.format(stringArray);
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isType((Type)((Object)String.class));
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject instanceof Collection;
    }
}

