/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.collections;

import java.util.Collection;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionToSingleElement
extends AbstractContainerConverter {
    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return true;
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject instanceof Collection;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            if (destinationType.isPrimitive()) {
                throw new ConverterException("Could not convert null to primitive type");
            }
            return null;
        }
        Collection collection = (Collection)sourceObject;
        Object firstElement = collection.toArray()[0];
        Object elementConverted = this.elementConverter.convert(context, firstElement, destinationType);
        return elementConverted;
    }
}

