/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.collections;

import java.lang.reflect.Array;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayToArray
extends AbstractContainerConverter {
    public ArrayToArray() {
        this.useObjectPool = true;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            return null;
        }
        Object array = sourceObject;
        TypeReference<?> componentType = destinationType.getArrayComponentType();
        int arrayLength = Array.getLength(array);
        Class<?> componentTypeClass = componentType.getRawType();
        Object destinationArray = Array.newInstance(componentTypeClass, arrayLength);
        if (this.useObjectPool) {
            context.getConvertedObjectPool().add(this, sourceObject, destinationType, destinationArray);
        }
        for (int i = 0; i < arrayLength; ++i) {
            Object element = Array.get(array, i);
            Object elementConverted = this.elementConverter.convert(context, element, componentType);
            Array.set(destinationArray, i, elementConverted);
        }
        return destinationArray;
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isArray();
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject.getClass().isArray();
    }
}

