/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.beans;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.beans.IMapToBeanMapping;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapWithClassToBeanMapping
implements IMapToBeanMapping {
    private ClassLoader classLoader;

    public MapWithClassToBeanMapping(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String getPropertyName(Map<String, Object> map, String key, Object bean, Map<String, Method> setterMethods) {
        if ("class".equals(key)) {
            return null;
        }
        return key;
    }

    @Override
    public TypeReference<?> getConcreteDestinationType(Map<String, Object> map, TypeReference<?> destinationType) throws ConverterException {
        TypeReference<?> typeCorrespondingToMap = this.getTypeReference(map);
        if (typeCorrespondingToMap != null && typeCorrespondingToMap.isRawTypeSubOf(destinationType.getRawType())) {
            return typeCorrespondingToMap;
        }
        Class<?> rawType = destinationType.getRawType();
        if (rawType.isInterface() || Modifier.isAbstract(rawType.getModifiers())) {
            return null;
        }
        return destinationType;
    }

    protected TypeReference<?> getTypeReference(Map<String, Object> map) throws ConverterException {
        Object object = map.get("class");
        if (object instanceof TypeReference) {
            return (TypeReference)object;
        }
        if (object instanceof Type) {
            return TypeReference.get((Type)object);
        }
        if (object instanceof String) {
            String className = (String)object;
            try {
                Class<?> type = this.classLoader.loadClass(className);
                return TypeReference.get(type);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }
}

