/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.beans;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Map;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.converters.beans.DefaultMapToBeanMapping;
import net.entropysoft.transmorph.converters.beans.IBeanPropertyTypeProvider;
import net.entropysoft.transmorph.converters.beans.IMapToBeanMapping;
import net.entropysoft.transmorph.type.TypeReference;
import net.entropysoft.transmorph.utils.BeanUtils;
import net.entropysoft.transmorph.utils.ImmutableClasses;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapToBean
extends AbstractContainerConverter {
    private IBeanPropertyTypeProvider beanDestinationPropertyTypeProvider;
    private IMapToBeanMapping mapToBeanMapping = new DefaultMapToBeanMapping();

    public MapToBean() {
        this.useObjectPool = true;
    }

    public void setMapToBeanMapping(IMapToBeanMapping mapToBeanMapping) {
        this.mapToBeanMapping = mapToBeanMapping;
    }

    public IBeanPropertyTypeProvider getBeanDestinationPropertyTypeProvider() {
        return this.beanDestinationPropertyTypeProvider;
    }

    public void setBeanPropertyTypeProvider(IBeanPropertyTypeProvider beanDestinationPropertyTypeProvider) {
        this.beanDestinationPropertyTypeProvider = beanDestinationPropertyTypeProvider;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            return null;
        }
        Map sourceMap = (Map)sourceObject;
        TypeReference<?> concreteDestinationType = this.mapToBeanMapping.getConcreteDestinationType(sourceMap, destinationType);
        if (concreteDestinationType == null) {
            throw new ConverterException("Could not find concrete destination type for '" + destinationType.toHumanString() + "'");
        }
        Map<String, Method> setterMethods = BeanUtils.getSetters(concreteDestinationType.getRawType());
        Object resultBean = this.newBeanInstance(concreteDestinationType);
        if (this.useObjectPool) {
            context.getConvertedObjectPool().add(this, sourceObject, destinationType, resultBean);
        }
        for (Map.Entry entry : sourceMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String propertyName = this.mapToBeanMapping.getPropertyName(sourceMap, key, resultBean, setterMethods);
            if (propertyName == null) continue;
            Method method = setterMethods.get(propertyName);
            if (method == null) {
                throw new ConverterException(MessageFormat.format("Could not find property ''{0}'' in ''{1}''", propertyName, concreteDestinationType.toHumanString()));
            }
            Type parameterType = method.getGenericParameterTypes()[0];
            TypeReference<?> originalType = TypeReference.get(parameterType);
            TypeReference<?> propertyDestinationType = this.getBeanPropertyType(resultBean.getClass(), propertyName, originalType);
            Object valueConverted = this.elementConverter.convert(context, value, propertyDestinationType);
            try {
                method.invoke(resultBean, valueConverted);
            }
            catch (Exception e) {
                throw new ConverterException("Could not set property for bean", e);
            }
        }
        return resultBean;
    }

    protected Object newBeanInstance(TypeReference<?> destinationType) throws ConverterException {
        try {
            return destinationType.getRawType().newInstance();
        }
        catch (Exception e) {
            throw new ConverterException(MessageFormat.format("Could not create instance of ''{0}''", destinationType.toHumanString()), e);
        }
    }

    protected TypeReference<?> getBeanPropertyType(Class<?> clazz, String propertyName, TypeReference<?> originalType) {
        TypeReference<?> propertyDestinationType = null;
        if (this.beanDestinationPropertyTypeProvider != null) {
            propertyDestinationType = this.beanDestinationPropertyTypeProvider.getPropertyType(clazz, propertyName, originalType);
        }
        if (propertyDestinationType == null) {
            propertyDestinationType = originalType;
        }
        return propertyDestinationType;
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return !destinationType.isPrimitive() && !destinationType.isArray() && !ImmutableClasses.isKnownImmutableClass(destinationType.getRawType());
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        if (!(sourceObject instanceof Map)) {
            return false;
        }
        for (Object object : ((Map)sourceObject).keySet()) {
            if (object instanceof String) continue;
            return false;
        }
        return true;
    }
}

