/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.beans;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.converters.beans.IBeanToMapMapping2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBeanToMapMapping
implements IBeanToMapMapping2 {
    private boolean ignorePropertiesWithNoSetter = true;
    private boolean keepClass = false;
    private boolean ignoreNullValues = false;

    @Override
    public Map<String, Object> getOtherValues(Object bean) {
        if (this.keepClass) {
            HashMap<String, Object> otherValues = new HashMap<String, Object>(1);
            otherValues.put("class", bean.getClass());
            return otherValues;
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean select(Object bean, String propertyName, Method getterMethod, Method setterMethod) {
        if ("class".equals(propertyName)) {
            return false;
        }
        return !this.ignorePropertiesWithNoSetter || setterMethod != null;
    }

    @Override
    public String getMapKey(Object bean, String propertyName, Object propertyValue, Method getterMethod, Method setterMethod) {
        if (propertyValue == null && this.ignoreNullValues) {
            return null;
        }
        return propertyName;
    }

    public void setIgnorePropertiesWithNoSetter(boolean ignorePropertiesWithNoSetter) {
        this.ignorePropertiesWithNoSetter = ignorePropertiesWithNoSetter;
    }

    public void setIgnoreNullValues(boolean ignoreNullValues) {
        this.ignoreNullValues = ignoreNullValues;
    }

    public boolean isIgnorePropertiesWithNoSetter() {
        return this.ignorePropertiesWithNoSetter;
    }

    public void setKeepClass(boolean keepClass) {
        this.keepClass = keepClass;
    }

    public boolean isKeepClass() {
        return this.keepClass;
    }
}

