/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.beans;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.converters.beans.BeanToBeanMapping;
import net.entropysoft.transmorph.converters.beans.IBeanPropertyTypeProvider;
import net.entropysoft.transmorph.converters.beans.utils.ClassPair;
import net.entropysoft.transmorph.type.TypeReference;
import net.entropysoft.transmorph.utils.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanToBean
extends AbstractContainerConverter {
    private IBeanPropertyTypeProvider beanDestinationPropertyTypeProvider;
    private Map<ClassPair<?, ?>, BeanToBeanMapping> beanToBeanMappings = new HashMap();
    private boolean handleTargetClassSameAsSourceClass = true;

    public BeanToBean() {
        this.useObjectPool = true;
    }

    public IBeanPropertyTypeProvider getBeanDestinationPropertyTypeProvider() {
        return this.beanDestinationPropertyTypeProvider;
    }

    public void setBeanDestinationPropertyTypeProvider(IBeanPropertyTypeProvider beanDestinationPropertyTypeProvider) {
        this.beanDestinationPropertyTypeProvider = beanDestinationPropertyTypeProvider;
    }

    public boolean isHandleTargetClassSameAsSourceClass() {
        return this.handleTargetClassSameAsSourceClass;
    }

    public void setHandleTargetClassSameAsSourceClass(boolean useIfTargetClassSameAsSourceClass) {
        this.handleTargetClassSameAsSourceClass = useIfTargetClassSameAsSourceClass;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        Object resultBean;
        Class<?> destinationClass = destinationType.getRawType();
        if (sourceObject == null) {
            return null;
        }
        if (!this.canHandle(sourceObject.getClass(), destinationClass)) {
            throw new ConverterException("Could not get bean to bean mapping");
        }
        Map<String, Method> destinationSetters = BeanUtils.getSetters(destinationClass);
        try {
            resultBean = destinationClass.newInstance();
        }
        catch (Exception e) {
            throw new ConverterException(MessageFormat.format("Could not create instance of ''{0}''", destinationType.toHumanString()), e);
        }
        if (this.useObjectPool) {
            context.getConvertedObjectPool().add(this, sourceObject, destinationType, resultBean);
        }
        for (Map.Entry<String, Method> entry : destinationSetters.entrySet()) {
            Object sourcePropertyValue;
            String destinationPropertyName = entry.getKey();
            Method destinationMethod = entry.getValue();
            Method sourceMethod = this.getPropertySourceMethod(sourceObject, resultBean, destinationPropertyName);
            if (sourceMethod == null) continue;
            try {
                sourcePropertyValue = sourceMethod.invoke(sourceObject, new Object[0]);
            }
            catch (Exception e) {
                throw new ConverterException("Could not get property for bean", e);
            }
            Type parameterType = destinationMethod.getGenericParameterTypes()[0];
            TypeReference<?> originalType = TypeReference.get(parameterType);
            TypeReference<?> propertyDestinationType = this.getBeanPropertyType(resultBean.getClass(), destinationPropertyName, originalType);
            Object destinationPropertyValue = this.elementConverter.convert(context, sourcePropertyValue, propertyDestinationType);
            try {
                destinationMethod.invoke(resultBean, destinationPropertyValue);
            }
            catch (Exception e) {
                throw new ConverterException("Could not set property for bean", e);
            }
        }
        return resultBean;
    }

    private Method getPropertySourceMethod(Object sourceObject, Object destinationObject, String destinationProperty) {
        BeanToBeanMapping beanToBeanMapping = this.beanToBeanMappings.get(ClassPair.get(sourceObject.getClass(), destinationObject.getClass()));
        String sourceProperty = null;
        if (beanToBeanMapping != null) {
            sourceProperty = beanToBeanMapping.getSourceProperty(destinationProperty);
        }
        if (sourceProperty == null) {
            sourceProperty = destinationProperty;
        }
        return BeanUtils.getGetterPropertyMethod(sourceObject.getClass(), sourceProperty);
    }

    protected TypeReference<?> getBeanPropertyType(Class<?> clazz, String propertyName, TypeReference<?> originalType) {
        TypeReference<?> propertyDestinationType = null;
        if (this.beanDestinationPropertyTypeProvider != null) {
            propertyDestinationType = this.beanDestinationPropertyTypeProvider.getPropertyType(clazz, propertyName, originalType);
        }
        if (propertyDestinationType == null) {
            propertyDestinationType = originalType;
        }
        return propertyDestinationType;
    }

    public void addBeanToBeanMapping(BeanToBeanMapping beanToBeanMapping) {
        this.beanToBeanMappings.put(ClassPair.get(beanToBeanMapping.getSourceClass(), beanToBeanMapping.getDestinationClass()), beanToBeanMapping);
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        try {
            destinationType.getRawType().getConstructor(new Class[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        return true;
    }

    private boolean canHandle(Class<?> sourceObjectClass, Class<?> destinationClass) {
        if (this.handleTargetClassSameAsSourceClass && sourceObjectClass.equals(destinationClass)) {
            return true;
        }
        BeanToBeanMapping beanToBeanMapping = this.beanToBeanMappings.get(ClassPair.get(sourceObjectClass, destinationClass));
        return beanToBeanMapping != null;
    }

    @Override
    public boolean canHandle(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) {
        if (sourceObject != null && !this.canHandle(sourceObject.getClass(), destinationType.getRawType())) {
            return false;
        }
        return super.canHandle(context, sourceObject, destinationType);
    }
}

