/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubTypeConverter
extends AbstractContainerConverter {
    private TypeReference<?> destinationType;
    private TypeReference<?>[] destinationSubTypes;
    private Map<TypeReference<?>, IConverter> typeReferenceToConverter = new HashMap();

    public SubTypeConverter(TypeReference<?> destinationType, TypeReference<?>[] destinationSubTypes) {
        this.destinationType = destinationType;
        this.destinationSubTypes = destinationSubTypes;
    }

    public void setConverter(TypeReference<?> destinationSubType, IConverter converter) {
        this.typeReferenceToConverter.put(destinationSubType, converter);
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return this.destinationType.isRawTypeSubOf(destinationType.getRawType());
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        return true;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        ConverterException firstException = null;
        for (TypeReference<?> destinationSubType : this.destinationSubTypes) {
            try {
                IConverter converter = this.typeReferenceToConverter.get(destinationSubType);
                if (converter == null) {
                    converter = this.elementConverter;
                }
                if (!converter.canHandle(context, sourceObject, destinationSubType)) continue;
                return converter.convert(context, sourceObject, destinationSubType);
            }
            catch (ConverterException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw new ConverterException(MessageFormat.format("Could not convert given object with class ''{0}'' to object with type signature ''{1}''", sourceObject == null ? "null" : sourceObject.getClass().getName(), destinationType), firstException);
        }
        throw new ConverterException(MessageFormat.format("Could not convert given object with class ''{0}'' to object with type signature ''{1}''", sourceObject == null ? "null" : sourceObject.getClass().getName(), destinationType));
    }
}

