/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractSimpleConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToInputStream
extends AbstractSimpleConverter<String, InputStream> {
    private String charsetName = "UTF-8";

    public StringToInputStream() {
        super(String.class, InputStream.class);
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    @Override
    public InputStream doConvert(ConversionContext context, String sourceObject, TypeReference<?> destinationType) throws ConverterException {
        try {
            return new ByteArrayInputStream(sourceObject.getBytes(this.charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new ConverterException("Could not convert String to Inputstream", e);
        }
    }
}

