/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractSimpleConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToDate
extends AbstractSimpleConverter<String, Date> {
    private DateFormat dateFormat = new SimpleDateFormat();

    public StringToDate() {
        super(String.class, Date.class);
        this.dateFormat.setLenient(false);
        this.useObjectPool = false;
    }

    public synchronized DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public synchronized void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date doConvert(ConversionContext context, String sourceObject, TypeReference<?> destinationType) throws ConverterException {
        Date result;
        ParsePosition pos = new ParsePosition(0);
        StringToDate stringToDate = this;
        synchronized (stringToDate) {
            result = this.dateFormat.parse(sourceObject, pos);
        }
        if (pos.getIndex() < sourceObject.length()) {
            result = null;
        }
        if (result == null) {
            throw new ConverterException(MessageFormat.format("Could not convert ''{0}'' to a date", sourceObject));
        }
        return result;
    }
}

