/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.converters.AbstractConverter;
import net.entropysoft.transmorph.converters.beans.utils.ClassPair;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticConverter
extends AbstractConverter {
    private final Map<ClassPair<?, ?>, IConverter> converters = new HashMap();

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return true;
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        return true;
    }

    @Override
    public boolean canHandle(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) {
        if (!super.canHandle(context, sourceObject, destinationType)) {
            return false;
        }
        if (sourceObject == null) {
            return true;
        }
        IConverter converter = this.getConverter(sourceObject.getClass(), destinationType.getRawType());
        if (converter == null) {
            return false;
        }
        return converter.canHandle(context, sourceObject, destinationType);
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            if (destinationType.isPrimitive()) {
                throw new ConverterException("Could not convert null to primitive type");
            }
            return null;
        }
        IConverter converter = this.getConverter(sourceObject.getClass(), destinationType.getRawType());
        return converter.convert(context, sourceObject, destinationType);
    }

    private IConverter getConverter(Class<?> source, Class<?> dest) {
        ClassPair<?, ?> classPair = ClassPair.get(source, dest);
        return this.converters.get(classPair);
    }

    public void addConverter(Class<?> source, Class<?> dest, IConverter converter) {
        ClassPair<?, ?> classPair = ClassPair.get(source, dest);
        this.converters.put(classPair, converter);
    }
}

