/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.lang.reflect.Array;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleElementToArray
extends AbstractContainerConverter {
    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            return null;
        }
        TypeReference<?> elementType = destinationType.getArrayElementType();
        Class<?> destinationComponentType = elementType.getRawType();
        Object destinationArray = Array.newInstance(destinationComponentType, 1);
        Object elementConverted = this.elementConverter.convert(context, sourceObject, elementType);
        Array.set(destinationArray, 0, elementConverted);
        return destinationArray;
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        if (!destinationType.isArray()) {
            return false;
        }
        return destinationType.getArrayNumDimensions() <= 1;
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        return true;
    }
}

