/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SameTypeConverter
extends AbstractContainerConverter {
    private Map<TypeReference<?>, IConverter> typeReferenceToConverter = new HashMap();

    public void setConverter(TypeReference<?> destinationSubType, IConverter converter) {
        this.typeReferenceToConverter.put(destinationSubType, converter);
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return true;
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        return true;
    }

    @Override
    public boolean canHandle(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) {
        if (!super.canHandle(context, sourceObject, destinationType)) {
            return false;
        }
        return sourceObject == null || destinationType.isRawTypeInstance(sourceObject);
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            return null;
        }
        TypeReference<?> sourceObjectTypeReference = TypeReference.get(sourceObject.getClass());
        try {
            IConverter converter = this.typeReferenceToConverter.get(sourceObjectTypeReference);
            if (converter == null) {
                converter = this.elementConverter;
            }
            if (converter.canHandle(context, sourceObject, sourceObjectTypeReference)) {
                return converter.convert(context, sourceObject, sourceObjectTypeReference);
            }
        }
        catch (ConverterException e) {
            throw new ConverterException(MessageFormat.format("Could not convert given object with class ''{0}'' to object with type signature ''{1}''", sourceObject == null ? "null" : sourceObject.getClass().getName(), destinationType), e);
        }
        throw new ConverterException(MessageFormat.format("Could not convert given object with class ''{0}'' to object with type signature ''{1}''", sourceObject == null ? "null" : sourceObject.getClass().getName(), destinationType));
    }
}

