/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.lang.reflect.Type;
import java.net.URL;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToString
extends AbstractConverter {
    public static final Class<?>[] ALL_SOURCE_CLASSES = new Class[]{Object.class};
    private Class<?>[] handledSourceClasses = ALL_SOURCE_CLASSES;
    private boolean failIfDefaultObjectToString = true;

    public ObjectToString() {
        this.useObjectPool = false;
    }

    public Class<?>[] getHandledSourceClasses() {
        return this.handledSourceClasses;
    }

    public void setHandledSourceClasses(Class<?>[] handledSourceClasses) {
        this.handledSourceClasses = handledSourceClasses;
    }

    public void setFailIfDefaultObjectToString(boolean failIfDefaultObjectToString) {
        this.failIfDefaultObjectToString = failIfDefaultObjectToString;
    }

    public boolean isFailIfDefaultObjectToString() {
        return this.failIfDefaultObjectToString;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            return null;
        }
        String result = sourceObject.toString();
        if (this.failIfDefaultObjectToString && this.isDefaultObjectToString(sourceObject, result)) {
            throw new ConverterException("Cannot convert to string : toString() method has not been overridden");
        }
        return result;
    }

    protected boolean isDefaultObjectToString(Object sourceObject, String str) {
        if (sourceObject instanceof URL) {
            return false;
        }
        return str.equals(this.getDefaultObjectToString(sourceObject));
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isType((Type)((Object)String.class));
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        for (Class<?> handledClass : this.handledSourceClasses) {
            if (!handledClass.isAssignableFrom(sourceObject.getClass())) continue;
            return true;
        }
        return false;
    }

    private String getDefaultObjectToString(Object object) {
        return object.getClass().getName() + "@" + Integer.toHexString(object.hashCode());
    }
}

