/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToObjectUsingConstructor
extends AbstractConverter {
    public static final Class<?>[] ALL_DESTINATION_CLASSES = null;
    public static final Class<?>[] NO_DESTINATION_CLASSES = new Class[0];
    private Class<?>[] handledDestinationClasses = NO_DESTINATION_CLASSES;

    public ObjectToObjectUsingConstructor() {
        this.useObjectPool = true;
    }

    public Class<?>[] getHandledDestinationClasses() {
        return this.handledDestinationClasses;
    }

    public void setHandledDestinationClasses(Class<?>[] handledDestinationClasses) {
        this.handledDestinationClasses = handledDestinationClasses;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        try {
            Constructor<?> compatibleConstructor = this.getCompatibleConstructor(destinationType.getRawType(), sourceObject.getClass());
            if (compatibleConstructor == null) {
                throw new ConverterException(MessageFormat.format("Could not convert ''{0}'' to destination type ''{1}''", sourceObject.getClass(), destinationType.toHumanString()));
            }
            return compatibleConstructor.newInstance(sourceObject);
        }
        catch (Exception e) {
            throw new ConverterException("Could not create an object with type '" + destinationType.toHumanString() + "' from object '" + sourceObject.getClass().getName() + "' using a constructor");
        }
    }

    public Constructor<?> getCompatibleConstructor(Class<?> type, Class<?> argumentType) {
        try {
            return type.getConstructor(argumentType);
        }
        catch (Exception e) {
            Class<?>[] types = type.getClasses();
            for (int i = 0; i < types.length; ++i) {
                try {
                    return type.getConstructor(types[i]);
                }
                catch (Exception e1) {
                    continue;
                }
            }
            return null;
        }
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        if (this.handledDestinationClasses == ALL_DESTINATION_CLASSES) {
            return true;
        }
        for (Class<?> handledClass : this.handledDestinationClasses) {
            if (!destinationType.isType(handledClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        return true;
    }
}

