/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.lang.reflect.Type;
import java.text.Format;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToFormattedString
extends AbstractContainerConverter {
    private Format format;
    private Class<?> sourceClass;
    private Class<?> formatExpectedClass;

    public ObjectToFormattedString() {
        this.useObjectPool = true;
    }

    public ObjectToFormattedString(Class<?> sourceClass, Format format) {
        this.useObjectPool = true;
        this.sourceClass = sourceClass;
        this.formatExpectedClass = sourceClass;
        this.format = format;
    }

    public ObjectToFormattedString(Class<?> sourceClass, Class<?> formatExpectedClass, Format format) {
        this.useObjectPool = true;
        this.sourceClass = sourceClass;
        this.formatExpectedClass = formatExpectedClass;
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            return null;
        }
        Object formatSource = sourceObject;
        if (this.sourceClass != this.formatExpectedClass) {
            formatSource = this.elementConverter.convert(context, sourceObject, TypeReference.get(this.formatExpectedClass));
        }
        return this.format.format(formatSource);
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isType((Type)((Object)String.class));
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return this.sourceClass.isInstance(sourceObject);
    }
}

