/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractConverter;
import net.entropysoft.transmorph.type.TypeReference;
import net.entropysoft.transmorph.utils.NumberInRange;
import net.entropysoft.transmorph.utils.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberToNumber
extends AbstractConverter {
    private Number nullReplacementForPrimitive = null;
    private boolean checkOutOfRange = true;

    public NumberToNumber() {
        this.useObjectPool = false;
    }

    public Number getNullReplacementForPrimitive() {
        return this.nullReplacementForPrimitive;
    }

    public void setNullReplacementForPrimitive(Number nullReplacement) {
        this.nullReplacementForPrimitive = nullReplacement;
    }

    public void setCheckOutOfRange(boolean checkOutOfRange) {
        this.checkOutOfRange = checkOutOfRange;
    }

    public boolean isCheckOutOfRange() {
        return this.checkOutOfRange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            if (!destinationType.isPrimitive()) return null;
            if (this.nullReplacementForPrimitive == null) throw new ConverterException("Cannot convert null to a primitive number");
            sourceObject = this.nullReplacementForPrimitive;
        }
        try {
            Number sourceNumber = (Number)sourceObject;
            if (destinationType.hasRawType(Number.class) || destinationType.hasRawType(sourceNumber.getClass())) {
                return sourceNumber;
            }
            if (destinationType.hasRawType(Byte.TYPE) || destinationType.hasRawType(Byte.class)) {
                this.checkInRangeIfNecessary(sourceNumber, NumberInRange.BYTE_MIN, NumberInRange.BYTE_MAX);
                return sourceNumber.byteValue();
            }
            if (destinationType.hasRawType(Double.TYPE) || destinationType.hasRawType(Double.class)) {
                this.checkInRangeIfNecessary(sourceNumber, NumberInRange.DOUBLE_MIN, NumberInRange.DOUBLE_MAX);
                return sourceNumber.doubleValue();
            }
            if (destinationType.hasRawType(Float.TYPE) || destinationType.hasRawType(Float.class)) {
                this.checkInRangeIfNecessary(sourceNumber, NumberInRange.FLOAT_MIN, NumberInRange.FLOAT_MAX);
                return Float.valueOf(sourceNumber.floatValue());
            }
            if (destinationType.hasRawType(Integer.TYPE) || destinationType.hasRawType(Integer.class)) {
                this.checkInRangeIfNecessary(sourceNumber, NumberInRange.INTEGER_MIN, NumberInRange.INTEGER_MAX);
                return sourceNumber.intValue();
            }
            if (destinationType.hasRawType(Long.TYPE) || destinationType.hasRawType(Long.class)) {
                this.checkInRangeIfNecessary(sourceNumber, NumberInRange.LONG_MIN, NumberInRange.LONG_MAX);
                return sourceNumber.longValue();
            }
            if (destinationType.hasRawType(Short.TYPE) || destinationType.hasRawType(Short.class)) {
                this.checkInRangeIfNecessary(sourceNumber, NumberInRange.SHORT_MIN, NumberInRange.SHORT_MAX);
                return sourceNumber.shortValue();
            }
            if (destinationType.hasRawType(BigInteger.class)) {
                return NumberUtils.getBigInteger(sourceNumber);
            }
            if (!destinationType.hasRawType(BigDecimal.class)) throw new ConverterException("Could not convert");
            return NumberUtils.getBigDecimal(sourceNumber);
        }
        catch (NumberFormatException e) {
            throw new ConverterException("Could not convert", e);
        }
    }

    private void checkInRangeIfNecessary(Number number, BigInteger min, BigInteger max) throws ConverterException {
        if (this.checkOutOfRange && !NumberInRange.isInRange(number, min, max)) {
            throw new ConverterException(MessageFormat.format("Could not convert {0} : out of range [{1},{2}]", number, min, max));
        }
    }

    private void checkInRangeIfNecessary(Number number, BigDecimal min, BigDecimal max) throws ConverterException {
        if (this.checkOutOfRange && !NumberInRange.isInRange(number, min, max)) {
            throw new ConverterException(MessageFormat.format("Could not convert {0} : out of range [{1},{2}]", number, min, max));
        }
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isNumber();
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject instanceof Number;
    }
}

