/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiStepConverter
extends AbstractContainerConverter {
    private TypeReference<?>[] types;
    private IConverter[] stepConverters;

    public MultiStepConverter(TypeReference<?>[] types, IConverter[] stepConverters) {
        this.types = types;
        this.setStepConverters(stepConverters);
    }

    public MultiStepConverter(TypeReference<?>[] types) {
        this.types = types;
    }

    public void setStepConverters(IConverter[] stepConverters) {
        if (stepConverters.length != this.types.length - 1) {
            throw new IllegalArgumentException("stepConverters does not have correct length. It must have one less element than types");
        }
        this.stepConverters = stepConverters;
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.equals(this.types[this.types.length - 1]);
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        return this.types[0].isRawTypeInstance(sourceObject);
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        Object stepSourceObject = sourceObject;
        for (int i = 1; i < this.types.length; ++i) {
            IConverter stepConverter = this.stepConverters == null ? this.elementConverter : this.stepConverters[i - 1];
            stepSourceObject = stepConverter.convert(context, stepSourceObject, this.types[i]);
        }
        return stepSourceObject;
    }
}

