/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.text.MessageFormat;
import java.util.LinkedList;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IContainerConverter;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiConverter
extends AbstractContainerConverter {
    private LinkedList<IConverter> converterList;
    private boolean canReorder;

    public MultiConverter(IConverter ... converters) {
        this(false, converters);
    }

    public MultiConverter(boolean canReorder, IConverter ... converters) {
        this.useObjectPool = false;
        this.canReorder = canReorder;
        this.converterList = new LinkedList();
        for (IConverter converter : converters) {
            this.addConverter(converter);
        }
    }

    public void addConverter(int index, IConverter converter) {
        IContainerConverter containerConverter;
        this.converterList.add(index, converter);
        if (converter instanceof IContainerConverter && (containerConverter = (IContainerConverter)converter).getElementConverter() == null) {
            containerConverter.setElementConverter(this.elementConverter);
        }
    }

    public void addConverter(IConverter converter) {
        IContainerConverter containerConverter;
        this.converterList.add(converter);
        if (converter instanceof IContainerConverter && (containerConverter = (IContainerConverter)converter).getElementConverter() == null) {
            containerConverter.setElementConverter(this.elementConverter);
        }
    }

    public void removeConverter(IConverter converter) {
        this.converterList.remove(converter);
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        ConverterException firstException = null;
        if (this.canReorder && this.converterList.size() > 1) {
            block13: {
                IConverter firstConverter = this.converterList.getFirst();
                if (firstConverter.canHandle(context, sourceObject, destinationType)) {
                    try {
                        return firstConverter.convert(context, sourceObject, destinationType);
                    }
                    catch (ConverterException e) {
                        if (firstException != null) break block13;
                        firstException = e;
                    }
                }
            }
            IConverter[] converters = this.converterList.toArray(new IConverter[this.converterList.size()]);
            for (int i = 1; i < converters.length; ++i) {
                IConverter converter = converters[i];
                if (!converter.canHandle(context, sourceObject, destinationType)) continue;
                try {
                    Object result = converter.convert(context, sourceObject, destinationType);
                    if (this.converterList.getFirst() != converter) {
                        this.converterList.remove(converter);
                        this.converterList.addFirst(converter);
                    }
                    return result;
                }
                catch (ConverterException e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
        } else {
            for (IConverter converter : this.converterList) {
                if (!converter.canHandle(context, sourceObject, destinationType)) continue;
                try {
                    Object result = converter.convert(context, sourceObject, destinationType);
                    return result;
                }
                catch (ConverterException e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
        }
        if (firstException != null) {
            throw new ConverterException(MessageFormat.format("Could not convert given object with class ''{0}'' to object with type signature ''{1}''", sourceObject == null ? "null" : sourceObject.getClass().getName(), destinationType), firstException);
        }
        throw new ConverterException(MessageFormat.format("Could not convert given object with class ''{0}'' to object with type signature ''{1}''", sourceObject == null ? "null" : sourceObject.getClass().getName(), destinationType));
    }

    @Override
    public void setElementConverter(IConverter elementConverter) {
        super.setElementConverter(elementConverter);
        for (IConverter converter : this.converterList) {
            IContainerConverter containerConverter;
            if (!(converter instanceof IContainerConverter) || (containerConverter = (IContainerConverter)converter).getElementConverter() != null) continue;
            containerConverter.setElementConverter(this.elementConverter);
        }
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return true;
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        return true;
    }

    @Override
    protected boolean canBeAddedToUsedConverters() {
        return false;
    }
}

