/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractConverter;
import net.entropysoft.transmorph.converters.NumberToNumber;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattedStringToNumber
extends AbstractConverter {
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private NumberToNumber numberToNumberConverter = new NumberToNumber();

    public FormattedStringToNumber() {
        this.useObjectPool = true;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        Number number;
        if (sourceObject == null) {
            if (destinationType.isPrimitive()) {
                throw new ConverterException("Cannot convert null to a primitive number");
            }
            return null;
        }
        String sourceString = (String)sourceObject;
        ParsePosition pos = new ParsePosition(0);
        FormattedStringToNumber formattedStringToNumber = this;
        synchronized (formattedStringToNumber) {
            number = this.numberFormat.parse(sourceString, pos);
        }
        if (pos.getIndex() < sourceString.length()) {
            number = null;
        }
        if (number == null) {
            throw new ConverterException(MessageFormat.format("Could not convert ''{0}'' to a number", sourceString));
        }
        return this.numberToNumberConverter.convert(context, number, destinationType);
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isNumber();
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject instanceof String;
    }
}

