/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.context.ConvertedObjectPool;
import net.entropysoft.transmorph.modifiers.IModifier;
import net.entropysoft.transmorph.modifiers.ModifierException;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleConverter<S, D>
implements IConverter {
    private static final IModifier[] EMPTY_MODIFIERS = new IModifier[0];
    private IModifier<D>[] modifiers = EMPTY_MODIFIERS;
    private Class<S> sourceClass;
    private Class<D> destinationClass;
    protected boolean useObjectPool = false;

    protected AbstractSimpleConverter(Class<S> sourceClass, Class<D> destinationClass) {
        this.sourceClass = sourceClass;
        this.destinationClass = destinationClass;
    }

    public Class<S> getSourceClass() {
        return this.sourceClass;
    }

    public Class<D> getDestinationClass() {
        return this.destinationClass;
    }

    @Override
    public boolean canHandle(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) {
        return this.canHandleDestinationType(destinationType) && this.canHandleSourceObject(sourceObject);
    }

    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isType(this.destinationClass);
    }

    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return this.sourceClass.isInstance(sourceObject);
    }

    @Override
    public Object convert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        Object convertedObject;
        if (sourceObject == null) {
            if (destinationType.isPrimitive()) {
                throw new ConverterException("Cannot convert null to a primitive type");
            }
            return null;
        }
        ConvertedObjectPool objectPool = context.getConvertedObjectPool();
        if (this.useObjectPool && (convertedObject = objectPool.get(this, sourceObject, destinationType)) != null) {
            return convertedObject;
        }
        try {
            convertedObject = this.doConvert(context, sourceObject, destinationType);
            convertedObject = this.applyModifiers(context, convertedObject, destinationType);
            if (this.useObjectPool) {
                objectPool.add(this, sourceObject, destinationType, convertedObject);
            }
            if (context.isStoreUsedConverters()) {
                context.getUsedConverters().addUsedConverter(this, sourceObject, destinationType);
            }
            return convertedObject;
        }
        catch (ConverterException e) {
            if (this.useObjectPool) {
                objectPool.remove(this, sourceObject, destinationType);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (this.useObjectPool) {
                objectPool.remove(this, sourceObject, destinationType);
            }
            throw e;
        }
    }

    public abstract D doConvert(ConversionContext var1, S var2, TypeReference<?> var3) throws ConverterException;

    protected D applyModifiers(ConversionContext context, D object, TypeReference<?> destinationType) throws ConverterException {
        D initialObject = object;
        for (IModifier<D> modifier : this.modifiers) {
            try {
                object = modifier.modify(context, object);
            }
            catch (ModifierException e) {
                throw new ConverterException(e.getMessage(), e);
            }
        }
        if (this.useObjectPool && object != initialObject && context.getConvertedObjectPool().get(this, initialObject, destinationType) != null) {
            throw new ConverterException("A modifier returned a different object than initial one whereas initial object has been added to object pool");
        }
        return object;
    }

    public IModifier<D>[] getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(IModifier<D>[] modifiers) {
        this.modifiers = modifiers;
    }
}

