/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.context.ConvertedObjectPool;
import net.entropysoft.transmorph.modifiers.IModifier;
import net.entropysoft.transmorph.modifiers.ModifierException;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConverter
implements IConverter {
    private static final IModifier[] EMPTY_MODIFIERS = new IModifier[0];
    private IModifier<?>[] modifiers = EMPTY_MODIFIERS;
    protected boolean useObjectPool = false;

    @Override
    public Object convert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        Object convertedObject;
        ConvertedObjectPool objectPool = context.getConvertedObjectPool();
        if (this.useObjectPool && (convertedObject = objectPool.get(this, sourceObject, destinationType)) != null) {
            return convertedObject;
        }
        try {
            convertedObject = this.doConvert(context, sourceObject, destinationType);
            convertedObject = this.applyModifiers(context, convertedObject, destinationType);
            if (this.useObjectPool) {
                objectPool.add(this, sourceObject, destinationType, convertedObject);
            }
            if (context.isStoreUsedConverters() && this.canBeAddedToUsedConverters()) {
                context.getUsedConverters().addUsedConverter(this, sourceObject, destinationType);
            }
            return convertedObject;
        }
        catch (ConverterException e) {
            if (this.useObjectPool) {
                objectPool.remove(this, sourceObject, destinationType);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (this.useObjectPool) {
                objectPool.remove(this, sourceObject, destinationType);
            }
            throw e;
        }
    }

    protected boolean canBeAddedToUsedConverters() {
        return true;
    }

    public abstract Object doConvert(ConversionContext var1, Object var2, TypeReference<?> var3) throws ConverterException;

    protected Object applyModifiers(ConversionContext context, Object object, TypeReference<?> destinationType) throws ConverterException {
        Object initialObject = object;
        for (IModifier<?> modifier : this.modifiers) {
            try {
                object = modifier.modify(context, object);
            }
            catch (ModifierException e) {
                throw new ConverterException(e.getMessage(), e);
            }
        }
        if (this.useObjectPool && object != initialObject && context.getConvertedObjectPool().get(this, initialObject, destinationType) != null) {
            throw new ConverterException("A modifier returned a different object than initial one whereas initial object has been added to object pool");
        }
        if (this.modifiers.length > 0 && object != initialObject && object != null && !destinationType.isRawTypeInstance(object)) {
            throw new ConverterException("A modifier has modified the object type and it is no more compatible with expected destination type");
        }
        return object;
    }

    public IModifier<?>[] getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(IModifier<?>[] modifiers) {
        this.modifiers = modifiers;
    }

    public boolean isUseObjectPool() {
        return this.useObjectPool;
    }

    public void setUseObjectPool(boolean useObjectPool) {
        this.useObjectPool = useObjectPool;
    }

    @Override
    public boolean canHandle(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) {
        return this.canHandleDestinationType(destinationType) && this.canHandleSourceObject(sourceObject);
    }

    protected abstract boolean canHandleDestinationType(TypeReference<?> var1);

    protected abstract boolean canHandleSourceObject(Object var1);
}

