/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph;

import java.lang.reflect.Type;
import java.text.MessageFormat;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.converters.MultiConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transmorph {
    private MultiConverter multiConverter;

    public Transmorph(IConverter converter) {
        this(new IConverter[]{converter});
    }

    public Transmorph(IConverter ... converters) {
        this.multiConverter = new MultiConverter(false, converters);
        this.multiConverter.setElementConverter(this.multiConverter);
    }

    public <T> T convert(Object source, TypeReference<T> typeReference) throws ConverterException {
        return this.convert(new ConversionContext(), source, typeReference);
    }

    public <T> T convert(Object source, Class<T> clazz, Class<?>[] typeArgs) throws ConverterException {
        return clazz.cast(this.convert(new ConversionContext(), source, TypeReference.get(clazz, typeArgs)));
    }

    public Object convert(Object source, Type type) throws ConverterException {
        return this.convert(new ConversionContext(), source, TypeReference.get(type));
    }

    public <T> T convert(Object source, Class<T> clazz) throws ConverterException {
        return this.convert(new ConversionContext(), source, clazz);
    }

    public <T> T convert(ConversionContext context, Object source, Class<T> clazz) throws ConverterException {
        return this.convert(context, source, TypeReference.get(clazz));
    }

    public Object convert(ConversionContext context, Object source, Type type) throws ConverterException {
        return this.convert(context, source, TypeReference.get(type));
    }

    public <T> T convert(ConversionContext context, Object source, TypeReference<T> destinationType) throws ConverterException {
        try {
            return (T)this.multiConverter.convert(context, source, destinationType);
        }
        catch (ConverterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConverterException(MessageFormat.format("Could not convert given object with class ''{0}'' to object with type signature ''{1}''", source == null ? "null" : source.getClass().getName(), destinationType), e);
        }
    }

    public boolean canHandle(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) {
        return this.multiConverter.canHandle(context, sourceObject, destinationType);
    }
}

