/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.binding;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import net.sf.launch4j.binding.Binding;
import net.sf.launch4j.binding.BindingException;
import net.sf.launch4j.binding.IValidatable;
import net.sf.launch4j.binding.InvariantViolationException;
import net.sf.launch4j.binding.JComboBoxBinding;
import net.sf.launch4j.binding.JListBinding;
import net.sf.launch4j.binding.JRadioButtonBinding;
import net.sf.launch4j.binding.JTextAreaBinding;
import net.sf.launch4j.binding.JTextComponentBinding;
import net.sf.launch4j.binding.JToggleButtonBinding;
import net.sf.launch4j.binding.Messages;
import net.sf.launch4j.binding.OptComponentBinding;
import net.sf.launch4j.binding.OptJTextAreaBinding;
import org.apache.commons.beanutils.PropertyUtils;

public class Bindings
implements PropertyChangeListener,
ActionListener {
    private final Map<String, Binding> _bindings = new HashMap<String, Binding>();
    private final Map<String, Binding> _optComponents = new HashMap<String, Binding>();
    private boolean _modified = false;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("AccessibleValue".equals(prop) || "AccessibleText".equals(prop) || "AccessibleVisibleData".equals(prop) && evt.getSource().getClass().getName().contains("JList")) {
            this._modified = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._modified = true;
    }

    public boolean isModified() {
        return this._modified;
    }

    public Binding getBinding(String property) {
        return this._bindings.get(property);
    }

    private void registerPropertyChangeListener(JComponent c) {
        c.getAccessibleContext().addPropertyChangeListener(this);
    }

    private void registerPropertyChangeListener(JComponent[] components) {
        for (JComponent c : components) {
            c.getAccessibleContext().addPropertyChangeListener(this);
        }
    }

    private boolean isPropertyNull(IValidatable bean, Binding b) {
        try {
            for (String property : this._optComponents.keySet()) {
                if (!b.getProperty().startsWith(property)) continue;
                return PropertyUtils.getProperty((Object)bean, (String)property) == null;
            }
            return false;
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    public void setComponentsEnabled(String prefix, boolean enabled) {
        for (Binding b : this._bindings.values()) {
            if (!b.getProperty().startsWith(prefix)) continue;
            b.setEnabled(enabled);
        }
    }

    public void clear(IValidatable bean) {
        for (Binding b : this._optComponents.values()) {
            b.clear(bean);
        }
        for (Binding b : this._bindings.values()) {
            b.clear(bean);
        }
        this._modified = false;
    }

    public void put(IValidatable bean) {
        for (Binding b : this._optComponents.values()) {
            b.put(bean);
        }
        for (Binding b : this._bindings.values()) {
            if (this.isPropertyNull(bean, b)) {
                b.clear(null);
                continue;
            }
            b.put(bean);
        }
        this._modified = false;
    }

    public void get(IValidatable bean) {
        try {
            for (Binding b : this._optComponents.values()) {
                b.get(bean);
            }
            for (Binding b : this._bindings.values()) {
                if (this.isPropertyNull(bean, b)) continue;
                b.get(bean);
            }
            bean.checkInvariants();
            for (String property : this._optComponents.keySet()) {
                IValidatable component = (IValidatable)PropertyUtils.getProperty((Object)bean, (String)property);
                if (component == null) continue;
                component.checkInvariants();
            }
            this._modified = false;
        }
        catch (InvariantViolationException e) {
            e.setBinding(this.getBinding(e.getProperty()));
            throw e;
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    private Bindings add(Binding b) {
        if (this._bindings.containsKey(b.getProperty())) {
            throw new BindingException(Messages.getString("Bindings.duplicate.binding"));
        }
        this._bindings.put(b.getProperty(), b);
        return this;
    }

    public Bindings addOptComponent(String property, Class<? extends IValidatable> clazz, JToggleButton c, boolean enabledByDefault) {
        OptComponentBinding b = new OptComponentBinding(this, property, clazz, c, enabledByDefault);
        if (this._optComponents.containsKey(property)) {
            throw new BindingException(Messages.getString("Bindings.duplicate.binding"));
        }
        this._optComponents.put(property, b);
        return this;
    }

    public Bindings addOptComponent(String property, Class<? extends IValidatable> clazz, JToggleButton c) {
        return this.addOptComponent(property, clazz, c, false);
    }

    public Bindings add(String property, JTextComponent c, String defaultValue) {
        this.registerPropertyChangeListener(c);
        return this.add(new JTextComponentBinding(property, c, defaultValue));
    }

    public Bindings add(String property, JTextComponent c) {
        this.registerPropertyChangeListener(c);
        return this.add(new JTextComponentBinding(property, c, ""));
    }

    public Bindings add(String property, JToggleButton c, boolean defaultValue) {
        this.registerPropertyChangeListener(c);
        return this.add(new JToggleButtonBinding(property, c, defaultValue));
    }

    public Bindings add(String property, JToggleButton c) {
        this.registerPropertyChangeListener(c);
        return this.add(new JToggleButtonBinding(property, c, false));
    }

    public Bindings add(String property, JRadioButton[] cs, int defaultValue) {
        this.registerPropertyChangeListener(cs);
        return this.add(new JRadioButtonBinding(property, cs, defaultValue));
    }

    public Bindings add(String property, JRadioButton[] cs) {
        this.registerPropertyChangeListener(cs);
        return this.add(new JRadioButtonBinding(property, cs, 0));
    }

    public Bindings add(String property, JTextArea textArea, String defaultValue) {
        this.registerPropertyChangeListener(textArea);
        return this.add(new JTextComponentBinding(property, textArea, defaultValue));
    }

    public Bindings add(String property, JTextArea textArea) {
        this.registerPropertyChangeListener(textArea);
        return this.add(new JTextAreaBinding(property, textArea));
    }

    public Bindings add(String property, String stateProperty, JToggleButton button, JTextArea textArea) {
        this.registerPropertyChangeListener(button);
        this.registerPropertyChangeListener(textArea);
        return this.add(new OptJTextAreaBinding(property, stateProperty, button, textArea));
    }

    public <T> Bindings add(String property, JList<T> list) {
        this.registerPropertyChangeListener(list);
        return this.add(new JListBinding<T>(property, list));
    }

    public <T> Bindings add(String property, JComboBox<T> combo, int defaultValue) {
        combo.addActionListener(this);
        return this.add(new JComboBoxBinding<T>(property, combo, defaultValue));
    }

    public <T> Bindings add(String property, JComboBox<T> combo) {
        combo.addActionListener(this);
        return this.add(new JComboBoxBinding<T>(property, combo, 0));
    }
}

