/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.repo;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.jackson.repo.JacksonResource;
import net.sf.jasperreports.jackson.util.JacksonRuntimeException;
import net.sf.jasperreports.jackson.util.JacksonUtil;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;

public abstract class JacksonObjectPersistenceService
implements PersistenceService {
    private static final Method castorUtilMethod;
    private final JasperReportsContext jasperReportsContext;
    private final Class clazz;

    public JacksonObjectPersistenceService(JasperReportsContext jasperReportsContext, Class clazz) {
        this.jasperReportsContext = jasperReportsContext;
        this.clazz = clazz;
    }

    @Override
    public Resource load(String uri, RepositoryService repositoryService) {
        return this.load(null, uri, repositoryService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource load(RepositoryContext context, String uri, RepositoryService repositoryService) {
        InputStream is;
        JacksonResource<Object> resource = null;
        InputStreamResource isResource = repositoryService.getResource(context, uri, InputStreamResource.class);
        InputStream inputStream = is = isResource == null ? null : isResource.getInputStream();
        if (is != null) {
            Object value = null;
            boolean castorFallback = false;
            try {
                value = JacksonUtil.getInstance(this.jasperReportsContext).loadXml(is, this.clazz);
            }
            catch (JacksonRuntimeException e) {
                if (castorUtilMethod == null) {
                    throw e;
                }
                castorFallback = true;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (castorFallback) {
                isResource = repositoryService.getResource(context, uri, InputStreamResource.class);
                InputStream inputStream2 = is = isResource == null ? null : isResource.getInputStream();
                if (is != null) {
                    try {
                        value = castorUtilMethod.invoke(null, this.jasperReportsContext, is);
                    }
                    catch (IllegalAccessException | InvocationTargetException ex) {
                        throw new JRRuntimeException(ex);
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            resource = new JacksonResource<Object>();
            resource.setValue(value);
        }
        return resource;
    }

    @Override
    public void save(Resource resource, String uri, RepositoryService repositoryService) {
    }

    static {
        Method method = null;
        try {
            Class<?> castorUtilClass = JacksonObjectPersistenceService.class.getClassLoader().loadClass("net.sf.jasperreports.util.CastorUtil");
            method = castorUtilClass.getMethod("read", JasperReportsContext.class, InputStream.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        castorUtilMethod = method;
    }
}

