/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.util;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class TableUtil {
    public static final int TABLE_HEADER = 0;
    public static final int TABLE_FOOTER = 1;
    public static final int COLUMN_HEADER = 2;
    public static final int COLUMN_FOOTER = 3;
    public static final int COLUMN_DETAIL = 4;
    public static final int COLUMN_GROUP_HEADER = 5;
    public static final int COLUMN_GROUP_FOOTER = 6;
    private TableComponent table;
    private Map<Cell, Rectangle> boundsMap = new HashMap<Cell, Rectangle>();
    private JRReport report;

    public TableUtil(TableComponent table, JRReport report) {
        this.table = table;
        this.report = report;
        this.init(table);
    }

    public Map<Cell, Rectangle> getCellBounds() {
        return this.boundsMap;
    }

    public void refresh() {
        this.init(this.table);
    }

    public void init(TableComponent table) {
        this.boundsMap.clear();
        List<BaseColumn> allColumns = TableUtil.getAllColumns(table.getColumns());
        int y = 0;
        int h = 0;
        Rectangle r = new Rectangle(0, 0, 0, 0);
        for (BaseColumn bc : table.getColumns()) {
            r = this.initHeader(r, bc, 0, null);
            r.setLocation(r.x, y);
            if (h >= r.height) continue;
            h = r.height;
        }
        r = new Rectangle(0, y += h, 0, 0);
        h = 0;
        for (BaseColumn bc : table.getColumns()) {
            r = this.initHeader(r, bc, 2, null);
            r.setLocation(r.x, y);
            if (h >= r.height) continue;
            h = r.height;
        }
        List<?> groupsList = this.getGroupList();
        if (groupsList != null) {
            for (JRGroup jrGroup : groupsList) {
                r = new Rectangle(0, y += h, 0, 0);
                h = 0;
                for (BaseColumn bc : table.getColumns()) {
                    r = this.initHeader(r, bc, 5, jrGroup.getName());
                    r.setLocation(r.x, y);
                    if (h >= r.height) continue;
                    h = r.height;
                }
            }
        }
        r = new Rectangle(0, y += h, 0, 0);
        h = 0;
        for (BaseColumn bc : allColumns) {
            r = this.initDetail(r, bc);
            r.setLocation(r.x, y);
            if (h >= r.height) continue;
            h = r.height;
        }
        if (groupsList != null) {
            Iterator<Object> it = groupsList.listIterator(groupsList.size());
            while (it.hasPrevious()) {
                JRGroup jrGroup;
                jrGroup = (JRGroup)it.previous();
                r = new Rectangle(0, y += h, 0, 0);
                h = 0;
                for (BaseColumn bc : table.getColumns()) {
                    r = this.initFooter(r, bc, 6, jrGroup.getName());
                    r.setLocation(r.x, y);
                    if (h >= r.height) continue;
                    h = r.height;
                }
            }
        }
        r = new Rectangle(0, y += h, 0, 0);
        h = 0;
        for (BaseColumn bc : table.getColumns()) {
            r = this.initFooter(r, bc, 3, null);
            r.setLocation(r.x, y);
            if (h >= r.height) continue;
            h = r.height;
        }
        r = new Rectangle(0, y += h, 0, 0);
        for (BaseColumn bc : table.getColumns()) {
            r = this.initFooter(r, bc, 1, null);
            r.setLocation(r.x, y);
        }
    }

    public static List<BaseColumn> getAllColumns(TableComponent table) {
        return TableUtil.getAllColumns(table.getColumns());
    }

    public static List<BaseColumn> getAllColumns(List<BaseColumn> cols) {
        ArrayList<BaseColumn> lst = new ArrayList<BaseColumn>();
        for (BaseColumn bc : cols) {
            if (bc instanceof ColumnGroup) {
                lst.addAll(TableUtil.getAllColumns(((ColumnGroup)bc).getColumns()));
                continue;
            }
            lst.add(bc);
        }
        return lst;
    }

    private Rectangle initDetail(Rectangle p, BaseColumn bc) {
        int h = 0;
        int w = 0;
        if (bc != null && bc instanceof Column) {
            Cell c = ((Column)bc).getDetailCell();
            w = bc.getWidth();
            if (c != null) {
                h = c.getHeight();
            }
            this.boundsMap.put(c, new Rectangle(p.x, p.y, w, h));
        }
        return new Rectangle(p.x + w, p.y, w, h);
    }

    private Rectangle initHeader(Rectangle p, BaseColumn bc, int type, String grName) {
        int y = p.y;
        int h = 0;
        int w = bc.getWidth();
        Cell c = TableUtil.getCell(bc, type, grName);
        if (c != null) {
            y = p.y + c.getHeight();
            h = c.getHeight();
            this.boundsMap.put(c, new Rectangle(p.x, p.y, w, h));
        }
        if (bc instanceof ColumnGroup) {
            Rectangle pi = new Rectangle(p.x, y, w, h);
            int hi = 0;
            for (BaseColumn bcg : ((ColumnGroup)bc).getColumns()) {
                pi = this.initHeader(pi, bcg, type, grName);
                pi.setLocation(pi.x, y);
                if (hi >= pi.height) continue;
                hi = pi.height;
            }
            h += hi;
        }
        return new Rectangle(p.x + w, y, w, h);
    }

    private Rectangle initFooter(Rectangle p, BaseColumn bc, int type, String grName) {
        int y = p.y;
        int h = 0;
        int w = bc.getWidth();
        Cell c = TableUtil.getCell(bc, type, grName);
        if (bc instanceof ColumnGroup) {
            Rectangle pi = new Rectangle(p.x, y, w, h);
            int hi = 0;
            for (BaseColumn bcg : ((ColumnGroup)bc).getColumns()) {
                pi = this.initFooter(pi, bcg, type, grName);
                pi.setLocation(pi.x, y);
                if (hi >= pi.height) continue;
                hi = pi.height;
            }
            h += hi;
        }
        if (c != null) {
            y = p.y + h;
            int cellHeight = c.getHeight();
            this.boundsMap.put(c, new Rectangle(p.x, y, w, cellHeight));
            h += cellHeight;
        }
        return new Rectangle(p.x + w, y, w, h);
    }

    public Rectangle getBounds(int width, Cell cell, BaseColumn col) {
        Rectangle b = this.boundsMap.get(cell);
        if (b != null) {
            return b;
        }
        int w = col != null ? col.getWidth() : 0;
        int h = cell != null ? cell.getHeight() : 0;
        return new Rectangle(0, 0, w, h);
    }

    public List<?> getGroupList() {
        return TableUtil.getGroupList(this.table, this.report);
    }

    public static List<?> getGroupList(TableComponent table, JRReport report) {
        List<JRGroup> groupsList = null;
        JRDatasetRun datasetRun = table.getDatasetRun();
        if (datasetRun != null) {
            String dataSetName = datasetRun.getDatasetName();
            JRDataset[] datasets = report.getDatasets();
            if (datasets != null && dataSetName != null) {
                for (JRDataset ds : datasets) {
                    JRGroup[] groups = ds.getGroups();
                    if (!dataSetName.equals(ds.getName()) || groups == null) continue;
                    groupsList = Arrays.asList(groups);
                    break;
                }
            }
        }
        return groupsList;
    }

    public static Cell getCell(BaseColumn bc, int type, String grName) {
        Cell cell = null;
        switch (type) {
            case 0: {
                cell = bc.getTableHeader();
                break;
            }
            case 1: {
                cell = bc.getTableFooter();
                break;
            }
            case 2: {
                cell = bc.getColumnHeader();
                break;
            }
            case 3: {
                cell = bc.getColumnFooter();
                break;
            }
            case 4: {
                if (!(bc instanceof Column)) break;
                cell = ((Column)bc).getDetailCell();
                break;
            }
            case 5: {
                cell = bc.getGroupHeader(grName);
                break;
            }
            case 6: {
                cell = bc.getGroupFooter(grName);
                break;
            }
        }
        return cell;
    }

    public static ColumnGroup getColumnGroupForColumn(BaseColumn column, List<BaseColumn> columns) {
        for (BaseColumn bc : columns) {
            if (!(bc instanceof ColumnGroup)) continue;
            ColumnGroup cg = (ColumnGroup)bc;
            if (cg.getColumns().contains(column)) {
                return cg;
            }
            return TableUtil.getColumnGroupForColumn(column, cg.getColumns());
        }
        return null;
    }

    public static <T extends JRElement> T getCellElement(Class<T> type, Cell cell, boolean oneElementPerCell) {
        List<JRChild> detailElements;
        List<JRChild> list = detailElements = cell == null ? null : cell.getChildren();
        if (detailElements == null || detailElements != null && oneElementPerCell && detailElements.size() != 1) {
            return null;
        }
        for (JRChild detailElement : detailElements) {
            if (!type.isInstance(detailElement)) continue;
            JRElement de = (JRElement)detailElement;
            return (T)de;
        }
        return null;
    }

    public static boolean isFilterable(JRTextField textField) {
        if (textField != null) {
            return EvaluationTimeEnum.getValueOrDefault(textField.getEvaluationTime()) == EvaluationTimeEnum.NOW;
        }
        return false;
    }

    public static boolean hasSingleChunkExpression(JRTextField textField) {
        if (textField != null) {
            JRExpressionChunk[] chunks;
            JRExpression textExpression = textField.getExpression();
            JRExpressionChunk[] jRExpressionChunkArray = chunks = textExpression == null ? null : textExpression.getChunks();
            return chunks != null && chunks.length == 1 && (chunks[0].getType() == 3 || chunks[0].getType() == 4);
        }
        return false;
    }

    public static int getColumnIndex(Column column, TableComponent table) {
        List<BaseColumn> columns = TableUtil.getAllColumns(table);
        return columns.indexOf(column);
    }

    public static List<ColumnGroup> getHierarchicalColumnGroupsForColumn(BaseColumn column, List<BaseColumn> columns, TableComponent table) {
        ArrayList<ColumnGroup> result = new ArrayList<ColumnGroup>();
        List<BaseColumn> cols = columns != null ? columns : table.getColumns();
        for (BaseColumn bc : cols) {
            if (!(bc instanceof ColumnGroup)) continue;
            if (((ColumnGroup)bc).getColumns().contains(column)) {
                result.add((ColumnGroup)bc);
                result.addAll(TableUtil.getHierarchicalColumnGroupsForColumn(bc, null, table));
                continue;
            }
            result.addAll(TableUtil.getHierarchicalColumnGroupsForColumn(column, ((ColumnGroup)bc).getColumns(), table));
        }
        return result;
    }

    public static <T extends JRElement> T getCellElement(Class<T> type, BaseColumn column, int sectionType, String groupName, TableComponent table) {
        T element;
        block1: {
            element = TableUtil.getCellElement(type, TableUtil.getCell(column, sectionType, groupName), false);
            if (element != null) break block1;
            List<ColumnGroup> colGroups = TableUtil.getHierarchicalColumnGroupsForColumn(column, table.getColumns(), table);
            for (ColumnGroup colGroup : colGroups) {
                if (colGroup.getGroupHeader(groupName) != null && (element = TableUtil.getCellElement(type, TableUtil.getCell(colGroup, sectionType, groupName), false)) != null) break;
            }
        }
        return element;
    }
}

