/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.ColumnFactory;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardGroupCell;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public abstract class StandardBaseColumn
implements BaseColumn,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_PRINT_WHEN_EXPRESSION = "printWhenExpression";
    public static final String PROPERTY_TABLE_HEADER = "tableHeader";
    public static final String PROPERTY_TABLE_FOOTER = "tableFooter";
    public static final String PROPERTY_COLUMN_HEADER = "columnHeader";
    public static final String PROPERTY_COLUMN_FOOTER = "columnFooter";
    public static final String PROPERTY_GROUP_HEADERS = "groupHeaders";
    public static final String PROPERTY_GROUP_FOOTERS = "groupFooters";
    public static final String PROPERTY_WIDTH = "width";
    private UUID uuid;
    private JRExpression printWhenExpression;
    private Cell tableHeader;
    private Cell tableFooter;
    private List<GroupCell> groupHeaders;
    private List<GroupCell> groupFooters;
    private Cell columnHeader;
    private Cell columnFooter;
    private Integer width;
    private JRPropertiesMap propertiesMap;
    private List<JRPropertyExpression> propertyExpressions = new ArrayList<JRPropertyExpression>();
    private transient JRPropertyChangeSupport eventSupport;

    public StandardBaseColumn() {
        this.groupHeaders = new ArrayList<GroupCell>();
        this.groupFooters = new ArrayList<GroupCell>();
    }

    public StandardBaseColumn(BaseColumn column, ColumnFactory factory) {
        this.uuid = column.getUUID();
        this.printWhenExpression = factory.getBaseObjectFactory().getExpression(column.getPrintWhenExpression());
        this.tableHeader = factory.createCell(column.getTableHeader());
        this.tableFooter = factory.createCell(column.getTableFooter());
        this.groupHeaders = factory.createGroupCells(column.getGroupHeaders());
        this.groupFooters = factory.createGroupCells(column.getGroupFooters());
        this.columnHeader = factory.createCell(column.getColumnHeader());
        this.columnFooter = factory.createCell(column.getColumnFooter());
        this.width = column.getWidth();
        this.propertiesMap = JRPropertiesMap.getPropertiesClone(column);
        this.copyPropertyExpressions(column, factory);
    }

    private void copyPropertyExpressions(BaseColumn column, ColumnFactory factory) {
        JRPropertyExpression[] props = column.getPropertyExpressions();
        if (props != null && props.length > 0) {
            this.propertyExpressions = new ArrayList<JRPropertyExpression>(props.length);
            for (int i = 0; i < props.length; ++i) {
                this.propertyExpressions.add(factory.getBaseObjectFactory().getPropertyExpression(props[i]));
            }
        }
    }

    @Override
    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public Cell getColumnHeader() {
        return this.columnHeader;
    }

    @Override
    public Cell getColumnFooter() {
        return this.columnFooter;
    }

    @Override
    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    public void setPrintWhenExpression(JRExpression printWhenExpression) {
        JRExpression old = this.printWhenExpression;
        this.printWhenExpression = printWhenExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_WHEN_EXPRESSION, old, this.printWhenExpression);
    }

    public void setColumnHeader(Cell header) {
        Cell old = this.columnHeader;
        this.columnHeader = header;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_HEADER, old, this.columnHeader);
    }

    public void setColumnFooter(Cell header) {
        Cell old = this.columnFooter;
        this.columnFooter = header;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_FOOTER, old, this.columnFooter);
    }

    @Override
    public Object clone() {
        StandardBaseColumn clone = null;
        try {
            clone = (StandardBaseColumn)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.tableHeader = JRCloneUtils.nullSafeClone(this.tableHeader);
        clone.tableFooter = JRCloneUtils.nullSafeClone(this.tableFooter);
        clone.groupHeaders = JRCloneUtils.cloneList(this.groupHeaders);
        clone.groupFooters = JRCloneUtils.cloneList(this.groupFooters);
        clone.columnHeader = JRCloneUtils.nullSafeClone(this.columnHeader);
        clone.columnFooter = JRCloneUtils.nullSafeClone(this.columnFooter);
        clone.printWhenExpression = JRCloneUtils.nullSafeClone(this.printWhenExpression);
        clone.propertyExpressions = JRCloneUtils.cloneList(this.propertyExpressions);
        clone.eventSupport = null;
        clone.uuid = null;
        return clone;
    }

    @Override
    public Cell getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(Cell tableHeader) {
        Cell old = this.tableHeader;
        this.tableHeader = tableHeader;
        this.getEventSupport().firePropertyChange(PROPERTY_TABLE_HEADER, old, this.tableHeader);
    }

    @Override
    public Cell getTableFooter() {
        return this.tableFooter;
    }

    public void setTableFooter(Cell tableFooter) {
        Cell old = this.tableFooter;
        this.tableFooter = tableFooter;
        this.getEventSupport().firePropertyChange(PROPERTY_TABLE_FOOTER, old, this.tableFooter);
    }

    @Override
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        Integer old = this.width;
        this.width = width;
        this.getEventSupport().firePropertyChange(PROPERTY_WIDTH, old, this.width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        StandardBaseColumn standardBaseColumn = this;
        synchronized (standardBaseColumn) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public List<GroupCell> getGroupHeaders() {
        return this.groupHeaders;
    }

    @Override
    public List<GroupCell> getGroupFooters() {
        return this.groupFooters;
    }

    protected int findGroupCellIndex(List<GroupCell> groupCells, String groupName) {
        int idx = -1;
        ListIterator<GroupCell> it = groupCells.listIterator();
        while (it.hasNext()) {
            GroupCell groupCell = it.next();
            if (!groupName.equals(groupCell.getGroupName())) continue;
            idx = it.previousIndex();
        }
        return idx;
    }

    @Override
    public Cell getGroupFooter(String groupName) {
        int idx = this.findGroupCellIndex(this.groupFooters, groupName);
        return idx < 0 ? null : this.groupFooters.get(idx).getCell();
    }

    @Override
    public Cell getGroupHeader(String groupName) {
        int idx = this.findGroupCellIndex(this.groupHeaders, groupName);
        return idx < 0 ? null : this.groupHeaders.get(idx).getCell();
    }

    public void setGroupHeaders(List<GroupCell> groupHeaders) {
        List<GroupCell> old = this.groupHeaders;
        this.groupHeaders = groupHeaders;
        this.getEventSupport().firePropertyChange(PROPERTY_GROUP_HEADERS, old, this.groupHeaders);
    }

    public void setGroupFooters(List<GroupCell> groupFooters) {
        List<GroupCell> old = this.groupFooters;
        this.groupFooters = groupFooters;
        this.getEventSupport().firePropertyChange(PROPERTY_GROUP_FOOTERS, old, this.groupFooters);
    }

    public void addGroupHeader(GroupCell groupCell) {
        this.groupHeaders.add(groupCell);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_GROUP_HEADERS, groupCell, this.groupHeaders.size() - 1);
    }

    public void addGroupFooter(GroupCell groupCell) {
        this.groupFooters.add(groupCell);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_GROUP_FOOTERS, groupCell, this.groupFooters.size() - 1);
    }

    public boolean removeGroupFooter(GroupCell groupCell) {
        int idx = this.groupFooters.indexOf(groupCell);
        if (idx >= 0) {
            this.groupFooters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_GROUP_FOOTERS, groupCell, idx);
        }
        return idx >= 0;
    }

    public boolean removeGroupHeader(GroupCell groupCell) {
        int idx = this.groupHeaders.indexOf(groupCell);
        if (idx >= 0) {
            this.groupHeaders.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_GROUP_HEADERS, groupCell, idx);
        }
        return idx >= 0;
    }

    public void setGroupFooter(String groupName, Cell cell) {
        int idx = this.findGroupCellIndex(this.groupFooters, groupName);
        if (idx >= 0) {
            GroupCell old = this.groupFooters.get(idx);
            if (cell == null) {
                this.groupFooters.remove(idx);
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_GROUP_FOOTERS, old, idx);
            } else {
                StandardGroupCell groupCell = new StandardGroupCell(groupName, cell);
                this.groupFooters.set(idx, groupCell);
                this.getEventSupport().fireIndexedPropertyChange(PROPERTY_GROUP_FOOTERS, idx, old, groupCell);
            }
        } else if (cell != null) {
            StandardGroupCell groupCell = new StandardGroupCell(groupName, cell);
            this.addGroupFooter(groupCell);
        }
    }

    public void setGroupHeader(String groupName, Cell cell) {
        int idx = this.findGroupCellIndex(this.groupHeaders, groupName);
        if (idx >= 0) {
            GroupCell old = this.groupHeaders.get(idx);
            if (cell == null) {
                this.groupHeaders.remove(idx);
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_GROUP_HEADERS, old, idx);
            } else {
                StandardGroupCell groupCell = new StandardGroupCell(groupName, cell);
                this.groupHeaders.set(idx, groupCell);
                this.getEventSupport().fireIndexedPropertyChange(PROPERTY_GROUP_HEADERS, idx, old, groupCell);
            }
        } else if (cell != null) {
            StandardGroupCell groupCell = new StandardGroupCell(groupName, cell);
            this.addGroupHeader(groupCell);
        }
    }

    @Override
    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        if (this.propertiesMap == null) {
            this.propertiesMap = new JRPropertiesMap();
        }
        return this.propertiesMap;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    @Override
    public JRPropertyExpression[] getPropertyExpressions() {
        JRPropertyExpression[] props = this.propertyExpressions.isEmpty() ? null : this.propertyExpressions.toArray(new JRPropertyExpression[this.propertyExpressions.size()]);
        return props;
    }

    @JsonSetter
    private void setPropertyExpressions(List<JRPropertyExpression> propertyExpressions) {
        if (propertyExpressions != null) {
            for (JRPropertyExpression propertyExpression : propertyExpressions) {
                this.addPropertyExpression(propertyExpression);
            }
        }
    }

    public void addPropertyExpression(JRPropertyExpression propertyExpression) {
        this.propertyExpressions.add(propertyExpression);
        this.getEventSupport().fireCollectionElementAddedEvent("propertyExpressions", propertyExpression, this.propertyExpressions.size() - 1);
    }

    public void removePropertyExpression(JRPropertyExpression propertyExpression) {
        int idx = this.propertyExpressions.indexOf(propertyExpression);
        if (idx >= 0) {
            this.propertyExpressions.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent("propertyExpressions", propertyExpression, idx);
        }
    }

    public JRPropertyExpression removePropertyExpression(String name) {
        JRPropertyExpression removed = null;
        ListIterator<JRPropertyExpression> it = this.propertyExpressions.listIterator();
        while (it.hasNext()) {
            JRPropertyExpression prop = it.next();
            if (!name.equals(prop.getName())) continue;
            removed = prop;
            int idx = it.previousIndex();
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent("propertyExpressions", removed, idx);
            break;
        }
        return removed;
    }

    @JsonIgnore
    public List<JRPropertyExpression> getPropertyExpressionsList() {
        return this.propertyExpressions;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.propertyExpressions == null) {
            this.propertyExpressions = new ArrayList<JRPropertyExpression>();
        }
    }
}

