/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.phantomjs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.phantomjs.PhantomJSProcess;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessOutputReader {
    private static final Log log = LogFactory.getLog(ProcessOutputReader.class);
    private PhantomJSProcess process;
    private String processId;
    private CountDownLatch startLatch;
    private volatile boolean confirmed;

    public ProcessOutputReader(PhantomJSProcess process) {
        this.process = process;
        this.processId = process.getId();
        this.startLatch = new CountDownLatch(1);
    }

    public void start() {
        OutputReader outputReader = new OutputReader();
        Thread outputThread = new Thread((Runnable)outputReader, "JR PhantomJS output " + this.processId);
        outputThread.setDaemon(true);
        outputThread.start();
        ErrorReader errorReader = new ErrorReader();
        Thread errorThread = new Thread((Runnable)errorReader, "JR PhantomJS error " + this.processId);
        errorThread.setDaemon(true);
        errorThread.start();
    }

    public boolean waitConfirmation(int processStartTimeout) {
        try {
            boolean done = this.startLatch.await(processStartTimeout, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.processId + " done " + done + ", confirmed " + this.confirmed));
            }
            return this.confirmed;
        }
        catch (InterruptedException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void signalEnd() {
        this.process.signalEnd();
        if (!this.confirmed) {
            this.startLatch.countDown();
        }
    }

    private class ErrorReader
    implements Runnable {
        private ErrorReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream processInput = ProcessOutputReader.this.process.getProcess().getErrorStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(processInput, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.error((Object)("PhantomJS " + ProcessOutputReader.this.processId + " error: " + line));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(ProcessOutputReader.this.processId + " error stream ended"));
                }
            }
            catch (IOException e) {
                log.error((Object)(ProcessOutputReader.this.processId + " error reading phantomjs output"), (Throwable)e);
            }
            finally {
                ProcessOutputReader.this.signalEnd();
            }
        }
    }

    private class OutputReader
    implements Runnable {
        private OutputReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream processInput = ProcessOutputReader.this.process.getProcess().getInputStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(processInput, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(ProcessOutputReader.this.processId + ": " + line));
                    }
                    if (!line.equals("PROCESS_STARTED")) continue;
                    ProcessOutputReader.this.confirmed = true;
                    ProcessOutputReader.this.startLatch.countDown();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(ProcessOutputReader.this.processId + " stream ended"));
                }
            }
            catch (IOException e) {
                log.error((Object)(ProcessOutputReader.this.processId + " error reading phantomjs output"), (Throwable)e);
            }
            finally {
                ProcessOutputReader.this.signalEnd();
            }
        }
    }
}

