/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import net.sf.jasperreports.engine.export.zip.AbstractZip;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;

public abstract class OasisZip
extends AbstractZip {
    public static final String MIME_TYPE_ODT = "text";
    public static final String MIME_TYPE_ODS = "spreadsheet";
    public static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private ExportZipEntry contentEntry;
    private ExportZipEntry stylesEntry;

    public OasisZip() throws IOException {
        this(MIME_TYPE_ODT);
    }

    public OasisZip(String mimeType) throws IOException {
        this.exportZipEntries = new ArrayList();
        this.contentEntry = this.createEntry("content.xml");
        this.exportZipEntries.add(this.contentEntry);
        this.createMetaEntry();
        this.createSettingsEntry();
        this.stylesEntry = this.createEntry("styles.xml");
        this.exportZipEntries.add(this.stylesEntry);
        this.createMimeEntry(mimeType);
        this.createManifestEntry(mimeType);
    }

    public ExportZipEntry getContentEntry() {
        return this.contentEntry;
    }

    public ExportZipEntry getStylesEntry() {
        return this.stylesEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMimeEntry(String mimetype) throws IOException {
        ExportZipEntry mimeEntry = this.createEntry("mimetype");
        Writer mimeWriter = null;
        try {
            mimeWriter = mimeEntry.getWriter();
            mimeWriter.write("application/vnd.oasis.opendocument." + mimetype);
            mimeWriter.flush();
            this.exportZipEntries.add(mimeEntry);
        }
        finally {
            if (mimeWriter != null) {
                try {
                    mimeWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createManifestEntry(String mimetype) throws IOException {
        ExportZipEntry manifestEntry = this.createEntry("META-INF/manifest.xml");
        Writer manifestWriter = null;
        try {
            manifestWriter = manifestEntry.getWriter();
            manifestWriter.write(PROLOG);
            manifestWriter.write("<!DOCTYPE manifest:manifest PUBLIC \"-//OpenOffice.org//DTD Manifest 1.0//EN\" \"Manifest.dtd\">\n");
            manifestWriter.write("<manifest:manifest xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\">\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"application/vnd.oasis.opendocument." + mimetype + "\" manifest:full-path=\"/\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"application/vnd.sun.xml.ui.configuration\" manifest:full-path=\"Configurations2/\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Pictures/\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"content.xml\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"styles.xml\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"meta.xml\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Thumbnails/thumbnail.png\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Thumbnails/\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"settings.xml\"/>\n");
            manifestWriter.write("</manifest:manifest>\n");
            manifestWriter.flush();
            this.exportZipEntries.add(manifestEntry);
        }
        finally {
            if (manifestWriter != null) {
                try {
                    manifestWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMetaEntry() throws IOException {
        ExportZipEntry metaEntry = this.createEntry("meta.xml");
        Writer metaWriter = null;
        try {
            metaWriter = metaEntry.getWriter();
            metaWriter.write(PROLOG);
            metaWriter.flush();
            this.exportZipEntries.add(metaEntry);
        }
        finally {
            if (metaWriter != null) {
                try {
                    metaWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSettingsEntry() throws IOException {
        ExportZipEntry settingsEntry = this.createEntry("settings.xml");
        Writer settingsWriter = null;
        try {
            settingsWriter = settingsEntry.getWriter();
            settingsWriter.write(PROLOG);
            settingsWriter.write("<office:document-settings \n");
            settingsWriter.write("xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" \n");
            settingsWriter.write("xmlns:xlink=\"http://www.w3.org/1999/xlink\" \n");
            settingsWriter.write("xmlns:config=\"urn:oasis:names:tc:opendocument:xmlns:config:1.0\" \n");
            settingsWriter.write("xmlns:ooo=\"http://openoffice.org/2004/office\"/>\n");
            settingsWriter.flush();
            this.exportZipEntries.add(settingsEntry);
        }
        finally {
            if (settingsWriter != null) {
                try {
                    settingsWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

