/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.XlsMetadataExporterConfiguration;
import net.sf.jasperreports.export.XlsMetadataReportConfiguration;

public abstract class JRXlsAbstractMetadataExporter<RC extends XlsMetadataReportConfiguration, C extends XlsMetadataExporterConfiguration, E extends JRExporterContext>
extends JRXlsAbstractExporter<RC, C, E> {
    public static final String PROPERTY_COLUMN_NAME = "net.sf.jasperreports.export.xls.column.name";
    public static final String PROPERTY_REPEAT_VALUE = "net.sf.jasperreports.export.xls.repeat.value";
    public static final String PROPERTY_DATA = "net.sf.jasperreports.export.xls.data";
    protected List<String> columnNames;
    protected Map<String, Integer> columnNamesMap;
    protected int rowIndex;
    boolean hasDefinedColumns;
    Map<String, Object> currentRow;
    Map<String, Object> repeatedValues;

    public JRXlsAbstractMetadataExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRXlsAbstractMetadataExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.maxColumnIndex = 255;
    }

    @Override
    protected void initExport() {
        super.initExport();
        this.currentRow = new HashMap<String, Object>();
        this.repeatedValues = new HashMap<String, Object>();
        this.onePagePerSheetMap.clear();
        this.sheetsBeforeCurrentReport = 0;
        this.sheetsBeforeCurrentReportMap.clear();
    }

    @Override
    protected void initReport() {
        super.initReport();
        this.setColumnNames();
    }

    protected void setColumnNames() {
        String[] columnNamesArray = ((XlsMetadataReportConfiguration)this.getCurrentItemConfiguration()).getColumnNames();
        this.hasDefinedColumns = columnNamesArray != null && columnNamesArray.length > 0;
        this.columnNames = new ArrayList<String>();
        this.columnNamesMap = new HashMap<String, Integer>();
        List<String> columnNamesList = JRStringUtil.split(columnNamesArray, ",");
        if (columnNamesList != null) {
            for (String columnName : columnNamesList) {
                if (this.columnNamesMap.containsKey(columnName)) continue;
                this.columnNames.add(columnName);
                this.columnNamesMap.put(columnName, this.columnNames.size());
            }
        }
    }

    @Override
    protected void exportReportToStream(OutputStream os) throws JRException, IOException {
        this.openWorkbook(os);
        this.sheetNamesMap = new HashMap();
        boolean pageExported = false;
        List<ExporterInputItem> items = this.exporterInput.getItems();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            this.defaultFont = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
            if (!this.hasGlobalSheetNames()) {
                this.sheetNamesIndex = 0;
            }
            XlsMetadataReportConfiguration configuration = (XlsMetadataReportConfiguration)this.getCurrentItemConfiguration();
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                int endPageIndex;
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int n = endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                if (configuration.isOnePagePerSheet().booleanValue()) {
                    this.pageIndex = startPageIndex;
                    while (this.pageIndex <= endPageIndex) {
                        if (Thread.interrupted()) {
                            throw new ExportInterruptedException();
                        }
                        JRPrintPage page = pages.get(this.pageIndex);
                        this.pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
                        JRXlsAbstractExporter.SheetInfo sheetInfo = this.getSheetInfo(configuration, null);
                        this.createSheet(sheetInfo);
                        ++this.sheetIndex;
                        ++this.sheetNamesIndex;
                        this.rowIndex = 0;
                        this.resetAutoFilters();
                        this.setFreezePane(sheetInfo.rowFreezeIndex, sheetInfo.columnFreezeIndex);
                        this.exportPage(page);
                        ++this.pageIndex;
                    }
                } else {
                    this.pageFormat = this.jasperPrint.getPageFormat(startPageIndex);
                    JRXlsAbstractExporter.SheetInfo sheetInfo = this.getSheetInfo(configuration, this.jasperPrint.getName());
                    this.createSheet(sheetInfo);
                    ++this.sheetIndex;
                    ++this.sheetNamesIndex;
                    this.resetAutoFilters();
                    this.setFreezePane(sheetInfo.rowFreezeIndex, sheetInfo.columnFreezeIndex);
                    if (this.filter instanceof ResetableExporterFilter) {
                        ((ResetableExporterFilter)this.filter).reset();
                    }
                    this.pageIndex = startPageIndex;
                    while (this.pageIndex <= endPageIndex) {
                        if (Thread.interrupted()) {
                            throw new ExportInterruptedException();
                        }
                        JRPrintPage page = pages.get(this.pageIndex);
                        this.pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
                        this.exportPage(page);
                        ++this.pageIndex;
                    }
                }
                pageExported = true;
            } else if (this.reportIndex == items.size() - 1 && !pageExported) {
                this.exportEmptyReport();
            }
            this.sheetsBeforeCurrentReport = configuration.isOnePagePerSheet() != false ? this.sheetIndex : this.sheetsBeforeCurrentReport + 1;
            ++this.reportIndex;
        }
        this.closeWorkbook(os);
    }

    protected int exportPage(JRPrintPage page) throws JRException {
        XlsMetadataReportConfiguration configuration = (XlsMetadataReportConfiguration)this.getCurrentItemConfiguration();
        List<JRPrintElement> elements = page.getElements();
        this.currentRow = new HashMap<String, Object>();
        this.rowIndex += configuration.isWriteHeader() != false ? 1 : 0;
        for (int i = 0; i < elements.size(); ++i) {
            int columnFreezeIndex;
            JRPrintElement element = elements.get(i);
            String sheetName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.sheet.name");
            if (sheetName != null) {
                this.setSheetName(sheetName);
            }
            if (element instanceof JRPrintLine) {
                this.exportLine((JRPrintLine)element);
            } else if (element instanceof JRPrintRectangle) {
                this.exportRectangle((JRPrintRectangle)element);
            } else if (element instanceof JRPrintEllipse) {
                this.exportRectangle((JRPrintEllipse)element);
            } else if (element instanceof JRPrintImage) {
                this.exportImage((JRPrintImage)element);
            } else if (element instanceof JRPrintText) {
                this.exportText((JRPrintText)element);
            } else if (element instanceof JRPrintFrame) {
                this.exportFrame((JRPrintFrame)element);
            } else if (element instanceof JRGenericPrintElement) {
                this.exportGenericElement((JRGenericPrintElement)element);
            }
            String currentColumnName = element.getPropertiesMap().getProperty(PROPERTY_COLUMN_NAME);
            String rowFreeze = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.freeze.row.edge");
            int rowFreezeIndex = rowFreeze == null ? -1 : (EdgeEnum.BOTTOM.getName().equals(rowFreeze) ? this.rowIndex + 1 : this.rowIndex);
            String columnFreeze = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.freeze.column.edge");
            int n = columnFreeze == null ? -1 : (columnFreezeIndex = EdgeEnum.RIGHT.getName().equals(columnFreeze) ? this.columnNamesMap.get(currentColumnName) + 1 : this.columnNamesMap.get(currentColumnName));
            if (rowFreezeIndex <= 0 && columnFreezeIndex <= 0) continue;
            this.setFreezePane(rowFreezeIndex, columnFreezeIndex);
        }
        if (this.columnNames.size() > this.maxColumnIndex + 1) {
            throw new JRException("export.xls.common.column.index.beyond.limit", new Object[]{this.columnNames.size(), this.maxColumnIndex + 1});
        }
        if (this.columnNames.size() > 0) {
            if (this.rowIndex == 1 && ((XlsMetadataReportConfiguration)this.getCurrentItemConfiguration()).isWriteHeader().booleanValue()) {
                this.writeReportHeader();
            }
            this.writeCurrentRow(this.currentRow, this.repeatedValues);
        }
        if (this.autoFilterStart != null) {
            this.setAutoFilter(this.autoFilterStart + ":" + (this.autoFilterEnd != null ? this.autoFilterEnd : this.autoFilterStart));
        } else if (this.autoFilterEnd != null) {
            this.setAutoFilter(this.autoFilterEnd + ":" + this.autoFilterEnd);
        }
        this.setRowLevels(null, null);
        JRExportProgressMonitor progressMonitor = configuration.getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
        return 0;
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement) {
        return textElement.getFullStyledText(this.noneSelector);
    }

    @Override
    protected int getImageBorderCorrection(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            if (lineWidth >= 2.0f) {
                return 2;
            }
            return 1;
        }
        return ((XlsMetadataReportConfiguration)this.getCurrentItemConfiguration()).isImageBorderFixEnabled() != false ? 1 : 0;
    }

    private String getSheetName(String sheetName) {
        if (this.sheetNames != null && this.sheetNamesIndex < this.sheetNames.length) {
            sheetName = this.sheetNames[this.sheetNamesIndex];
        }
        if (sheetName == null) {
            return "Page " + (this.sheetIndex + 1);
        }
        int crtIndex = 1;
        String txtIndex = "";
        if (this.sheetNamesMap.containsKey(sheetName)) {
            crtIndex = (Integer)this.sheetNamesMap.get(sheetName) + 1;
            txtIndex = String.valueOf(crtIndex);
        }
        this.sheetNamesMap.put(sheetName, crtIndex);
        String name = sheetName;
        if (txtIndex.length() > 0) {
            name = name + " " + txtIndex;
        }
        if (name.length() > 31) {
            name = (sheetName + " ").substring(0, 31 - txtIndex.length()) + txtIndex;
        }
        return name;
    }

    private JRXlsAbstractExporter.SheetInfo getSheetInfo(XlsMetadataReportConfiguration configuration, String name) {
        JRXlsAbstractExporter.SheetInfo sheetInfo = new JRXlsAbstractExporter.SheetInfo();
        sheetInfo.sheetName = this.getSheetName(name);
        sheetInfo.rowFreezeIndex = configuration.getFreezeRow() == null ? -1 : configuration.getFreezeRow();
        sheetInfo.columnFreezeIndex = configuration.getFreezeColumn() == null ? -1 : this.getColumnIndex(configuration.getFreezeColumn());
        sheetInfo.ignoreCellBackground = configuration.isIgnoreCellBackground();
        sheetInfo.ignoreCellBorder = configuration.isIgnoreCellBorder();
        sheetInfo.whitePageBackground = configuration.isWhitePageBackground();
        sheetInfo.sheetFirstPageIndex = this.pageIndex;
        sheetInfo.sheetFirstPageNumber = configuration.getFirstPageNumber();
        sheetInfo.sheetPageScale = configuration.getPageScale();
        sheetInfo.sheetShowGridlines = configuration.isShowGridLines();
        sheetInfo.tabColor = configuration.getSheetTabColor();
        return sheetInfo;
    }

    @Override
    protected String getFormula(JRPrintText text) {
        String formula = text.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.formula");
        if (formula != null && (formula = formula.trim()).startsWith("=")) {
            formula = formula.substring(1);
        }
        return formula;
    }

    protected boolean isColumnReadOnTime(Map<String, Object> currentRow, String currentColumnName) {
        int indexOfLastFilledColumn = -1;
        Set<String> currentlyFilledColumns = currentRow.keySet();
        for (String column : currentlyFilledColumns) {
            indexOfLastFilledColumn = Math.max(indexOfLastFilledColumn, this.columnNames.indexOf(column));
        }
        return indexOfLastFilledColumn < this.columnNames.indexOf(currentColumnName);
    }

    @Override
    protected void exportText(JRPrintText text, JRExporterGridCell cell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    public void exportImage(JRPrintImage image, JRExporterGridCell cell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
    }

    @Override
    protected void exportRectangle(JRPrintGraphicElement element, JRExporterGridCell cell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    protected void exportLine(JRPrintLine line, JRExporterGridCell cell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell cell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell cell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
    }

    @Override
    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    protected abstract ExporterNature getNature();

    @Override
    protected abstract void openWorkbook(OutputStream var1) throws JRException;

    @Override
    protected void createSheet(CutsInfo xCuts, JRXlsAbstractExporter.SheetInfo sheetInfo) {
        this.createSheet(sheetInfo);
    }

    protected abstract void createSheet(JRXlsAbstractExporter.SheetInfo var1);

    @Override
    protected abstract void closeWorkbook(OutputStream var1) throws JRException;

    protected void setColumnWidth(int col, int width) {
        this.setColumnWidth(col, width, false);
    }

    @Override
    protected abstract void setColumnWidth(int var1, int var2, boolean var3);

    protected void setRowHeight(int rowIndex, int lastRowHeight) throws JRException {
        this.setRowHeight(rowIndex, lastRowHeight, null, null);
    }

    @Override
    protected abstract void setRowHeight(int var1, int var2, Cut var3, XlsRowLevelInfo var4) throws JRException;

    protected abstract void exportText(JRPrintText var1) throws JRException;

    public abstract void exportImage(JRPrintImage var1) throws JRException;

    protected abstract void exportRectangle(JRPrintGraphicElement var1) throws JRException;

    protected abstract void exportLine(JRPrintLine var1) throws JRException;

    protected abstract void exportFrame(JRPrintFrame var1) throws JRException;

    protected abstract void exportGenericElement(JRGenericPrintElement var1) throws JRException;

    protected abstract void writeCurrentRow(Map<String, Object> var1, Map<String, Object> var2) throws JRException;

    protected abstract void writeReportHeader() throws JRException;
}

