/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.testing;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.testing.ReferenceTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestBatch {
    private static Logger log = LoggerFactory.getLogger(TestBatch.class);
    private static int DEFAULT_THREADS = 12;
    private static int TASK_TIMEOUT = 30;
    private static List<String> tagBlacklist = new ArrayList<String>();
    private URL testURL;
    private int threadsUsed;
    private List<SourceEntry> tests;
    private Map<String, Float> results;
    private int totalCount;
    private int completedCount;

    public TestBatch(URL testURL) {
        this(testURL, DEFAULT_THREADS);
    }

    public TestBatch(URL testURL, int threadCount) {
        this.threadsUsed = threadCount;
        this.testURL = testURL;
        this.tests = new LinkedList<SourceEntry>();
        this.results = new LinkedHashMap<String, Float>();
        this.parseToc();
    }

    public int getTestCount() {
        return this.tests.size();
    }

    private void parseToc() {
        try {
            URL tocURL = new URL(this.testURL, "reftest-toc.htm");
            DefaultDocumentSource docSource = new DefaultDocumentSource(tocURL.toString());
            DefaultDOMSource parser = new DefaultDOMSource(docSource);
            Document doc = parser.parse();
            NodeList tables = doc.getElementsByTagName("table");
            if (tables.getLength() == 1) {
                Element table = (Element)tables.item(0);
                NodeList bodies = table.getElementsByTagName("tbody");
                for (int bi = 0; bi < bodies.getLength(); ++bi) {
                    Element body = (Element)bodies.item(bi);
                    NodeList rows = body.getElementsByTagName("tr");
                    for (int ri = 0; ri < 1; ++ri) {
                        Element row = (Element)rows.item(ri);
                        NodeList links = row.getElementsByTagName("a");
                        if (links.getLength() > 0) {
                            Element a = (Element)links.item(0);
                            SourceEntry entry = new SourceEntry();
                            entry.name = a.getTextContent().trim();
                            entry.src = a.getAttribute("href");
                            NodeList tags = row.getElementsByTagName("abbr");
                            for (int ti = 0; ti < tags.getLength(); ++ti) {
                                Element tag = (Element)tags.item(ti);
                                entry.tags.add(tag.getTextContent().trim().toLowerCase());
                            }
                            this.tests.add(entry);
                            continue;
                        }
                        log.error("No links in table row");
                    }
                }
                log.info("Loaded " + this.tests.size() + " source entries");
            } else {
                log.error("Couldn't identify the TOC table");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void runTestsSingleList() {
        this.runTestsSingleList(null);
    }

    public void runTestsSingleList(List<String> selected) {
        ExecutorService exec = Executors.newFixedThreadPool(this.threadsUsed);
        List<Callable<Float>> list = this.getTestList(selected);
        this.totalCount = list.size();
        this.completedCount = 0;
        try {
            List<Future<Float>> futures = exec.invokeAll(list, list.size() * 5, TimeUnit.SECONDS);
            for (int i = 0; i < list.size(); ++i) {
                float tvalue;
                Future<Float> future = futures.get(i);
                String tname = ((ReferenceTestCase)list.get(i)).getName();
                try {
                    tvalue = future.get().floatValue();
                }
                catch (ExecutionException e) {
                    tvalue = 1.0f;
                }
                catch (CancellationException e) {
                    tvalue = 1.0f;
                }
                this.results.put(tname, Float.valueOf(tvalue));
            }
        }
        catch (InterruptedException e) {
            log.error("Interrupted: {}", (Object)e.getMessage());
        }
    }

    public void runTests() {
        this.runTests(null);
    }

    public void runTests(List<String> selected) {
        int i;
        if (this.threadsUsed == 1) {
            log.info("Test sequence mode");
            this.runTestsInSequence(selected);
            return;
        }
        ExecutorService exec = Executors.newFixedThreadPool(this.threadsUsed);
        List<Callable<Float>> list = this.getTestList(selected);
        ArrayList<Future<Float>> futures = new ArrayList<Future<Float>>(list.size());
        this.totalCount = list.size();
        this.completedCount = 0;
        for (i = 0; i < list.size(); ++i) {
            try {
                List<Future<Float>> fl = exec.invokeAll(list.subList(i, i + 1), TASK_TIMEOUT, TimeUnit.SECONDS);
                futures.add(fl.get(0));
                continue;
            }
            catch (InterruptedException e) {
                log.error("Test " + i + " interrupted: " + e.getMessage());
                futures.add(null);
            }
        }
        for (i = 0; i < futures.size(); ++i) {
            float tvalue;
            String tname = ((ReferenceTestCase)list.get(i)).getName();
            Future future = (Future)futures.get(i);
            if (future != null) {
                try {
                    tvalue = ((Float)future.get()).floatValue();
                }
                catch (ExecutionException e) {
                    log.error(tname + " (" + i + "): " + e.getMessage());
                    e.printStackTrace();
                    tvalue = 1.0f;
                }
                catch (CancellationException e) {
                    log.error(tname + " (" + i + "): " + e.getMessage());
                    e.printStackTrace();
                    tvalue = 1.0f;
                }
                catch (InterruptedException e) {
                    log.error(tname + " (" + i + "): " + e.getMessage());
                    e.printStackTrace();
                    tvalue = 1.0f;
                }
            } else {
                log.error(tname + " (" + i + "): result not available");
                tvalue = 1.0f;
            }
            this.results.put(tname, Float.valueOf(tvalue));
        }
    }

    public void runTestsInSequence(List<String> selected) {
        Runtime runtime = Runtime.getRuntime();
        long minFree = runtime.freeMemory();
        List<Callable<Float>> list = this.getTestList(selected);
        for (int i = 0; i < list.size(); ++i) {
            Callable<Float> test = list.get(i);
            String tname = ((ReferenceTestCase)test).getName();
            log.info("Test {}/{} {}", new Object[]{i, list.size(), tname});
            System.out.print("Test " + i + "/" + list.size() + " " + tname);
            try {
                Float result = test.call();
                this.results.put(tname, result);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            long free = runtime.freeMemory();
            if (free < minFree) {
                minFree = free;
            }
            list.set(i, null);
            if (i % 10 == 0) {
                System.gc();
            }
            System.out.println(" free:" + free / 1000L + " min:" + minFree / 1000L);
        }
    }

    private List<Callable<Float>> getTestList(List<String> selected) {
        LinkedList<Callable<Float>> ret = new LinkedList<Callable<Float>>();
        for (SourceEntry entry : this.tests) {
            boolean blacklisted = false;
            for (String tag : entry.tags) {
                if (!tagBlacklist.contains(tag)) continue;
                blacklisted = true;
            }
            if (!blacklisted && (selected == null || selected.contains(entry.name))) {
                try {
                    URL url = new URL(this.testURL, entry.src);
                    ReferenceTestCase test = new ReferenceTestCase(entry.name, url.toString());
                    ret.add(test);
                }
                catch (MalformedURLException e) {
                    log.error("getListTest: {}", (Object)e.getMessage());
                }
                continue;
            }
            log.info("Skipped " + entry.name);
        }
        return ret;
    }

    public float runTest(SourceEntry entry) {
        try {
            URL url = new URL(this.testURL, entry.src);
            ReferenceTestCase test = new ReferenceTestCase(entry.name, url.toString());
            float res = test.performTest();
            return res;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return -1.0f;
    }

    public Map<String, Float> getResults() {
        return this.results;
    }

    public float runTestByName(String name) {
        for (SourceEntry test : this.tests) {
            if (!test.name.equals(name)) continue;
            return this.runTest(test);
        }
        return -1.0f;
    }

    public void saveResults(String filename) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(filename));
            for (Map.Entry<String, Float> result : this.results.entrySet()) {
                out.println(result.getKey() + "," + result.getValue());
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void reportCompletion(ReferenceTestCase testCase) {
        ++this.completedCount;
        if (this.completedCount % 10 == 0) {
            log.info("Completed " + this.completedCount + "/" + this.totalCount);
        }
    }

    static {
        tagBlacklist.add("svg");
        tagBlacklist.add("dom/js");
    }

    public class SourceEntry {
        public String name;
        public String src;
        List<String> tags = new ArrayList<String>();
    }
}

