/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.render;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermAngle;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumber;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.ReplacedBox;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.render.BoxRenderer;

public class GraphicsRenderer
implements BoxRenderer {
    protected Graphics2D g;
    protected Map<ElementBox, AffineTransform> savedTransforms;

    public GraphicsRenderer(Graphics2D g) {
        this.g = g;
        this.savedTransforms = new HashMap<ElementBox, AffineTransform>();
    }

    @Override
    public void startElementContents(ElementBox elem) {
        AffineTransform at = this.createTransform(elem);
        if (at != null) {
            this.savedTransforms.put(elem, this.g.getTransform());
            this.g.transform(at);
        }
    }

    @Override
    public void finishElementContents(ElementBox elem) {
        AffineTransform origAt = this.savedTransforms.get(elem);
        if (origAt != null) {
            this.g.setTransform(origAt);
        }
    }

    @Override
    public void renderElementBackground(ElementBox elem) {
        AffineTransform origAt = null;
        AffineTransform at = this.createTransform(elem);
        if (at != null) {
            origAt = this.g.getTransform();
            this.g.transform(at);
        }
        elem.drawBackground(this.g);
        if (origAt != null) {
            this.g.setTransform(origAt);
        }
    }

    @Override
    public void renderTextContent(TextBox text) {
        text.drawContent(this.g);
    }

    @Override
    public void renderReplacedContent(ReplacedBox box) {
        AffineTransform at;
        AffineTransform origAt = null;
        if (box instanceof ElementBox && (at = this.createTransform((ElementBox)((Object)box))) != null) {
            origAt = this.g.getTransform();
            this.g.transform(at);
        }
        box.drawContent(this.g);
        if (origAt != null) {
            this.g.setTransform(origAt);
        }
    }

    @Override
    public void close() {
    }

    protected AffineTransform createTransform(ElementBox elem) {
        if (elem.isBlock() || elem.isReplaced()) {
            int oy;
            int ox;
            CSSDecoder dec = new CSSDecoder(elem.getVisualContext());
            Rectangle bounds = elem.getAbsoluteBorderBounds();
            CSSProperty.TransformOrigin origin = (CSSProperty.TransformOrigin)elem.getStyle().getProperty("transform-origin");
            if (origin == CSSProperty.TransformOrigin.list_values) {
                TermList values = (TermList)elem.getStyle().getValue(TermList.class, "transform-origin");
                ox = dec.getLength((TermLengthOrPercent)values.get(0), false, bounds.width / 2, 0, bounds.width);
                oy = dec.getLength((TermLengthOrPercent)values.get(1), false, bounds.height / 2, 0, bounds.height);
            } else {
                ox = bounds.width / 2;
                oy = bounds.height / 2;
            }
            ox += bounds.x;
            oy += bounds.y;
            AffineTransform ret = null;
            CSSProperty.Transform trans = (CSSProperty.Transform)elem.getStyle().getProperty("transform");
            if (trans == CSSProperty.Transform.list_values) {
                ret = new AffineTransform();
                ret.translate(ox, oy);
                TermList values = (TermList)elem.getStyle().getValue(TermList.class, "transform");
                for (Term term : values) {
                    if (!(term instanceof TermFunction)) continue;
                    TermFunction func = (TermFunction)term;
                    String fname = func.getFunctionName().toLowerCase();
                    if (fname.equals("rotate")) {
                        if (func.size() != 1 || !(func.get(0) instanceof TermAngle)) continue;
                        double theta = dec.getAngle((TermAngle)func.get(0));
                        ret.rotate(theta);
                        continue;
                    }
                    if (fname.equals("translate")) {
                        if (func.size() == 1 && func.get(0) instanceof TermLengthOrPercent) {
                            int tx = dec.getLength((TermLengthOrPercent)func.get(0), false, 0, 0, bounds.width);
                            ret.translate(tx, 0.0);
                            continue;
                        }
                        if (func.size() != 2 || !(func.get(0) instanceof TermLengthOrPercent) || !(func.get(1) instanceof TermLengthOrPercent)) continue;
                        int tx = dec.getLength((TermLengthOrPercent)func.get(0), false, 0, 0, bounds.width);
                        int ty = dec.getLength((TermLengthOrPercent)func.get(1), false, 0, 0, bounds.height);
                        ret.translate(tx, ty);
                        continue;
                    }
                    if (fname.equals("translatex")) {
                        if (func.size() != 1 || !(func.get(0) instanceof TermLengthOrPercent)) continue;
                        int tx = dec.getLength((TermLengthOrPercent)func.get(0), false, 0, 0, bounds.width);
                        ret.translate(tx, 0.0);
                        continue;
                    }
                    if (fname.equals("translatey")) {
                        if (func.size() != 1 || !(func.get(0) instanceof TermLengthOrPercent)) continue;
                        int ty = dec.getLength((TermLengthOrPercent)func.get(0), false, 0, 0, bounds.height);
                        ret.translate(0.0, ty);
                        continue;
                    }
                    if (fname.equals("scale")) {
                        if (func.size() == 1 && this.isNumber((Term)func.get(0))) {
                            float sx = this.getNumber((Term)func.get(0));
                            ret.scale(sx, sx);
                            continue;
                        }
                        if (func.size() != 2 || !this.isNumber((Term)func.get(0)) || !this.isNumber((Term)func.get(1))) continue;
                        float sx = this.getNumber((Term)func.get(0));
                        float sy = this.getNumber((Term)func.get(1));
                        ret.scale(sx, sy);
                        continue;
                    }
                    if (fname.equals("scalex")) {
                        if (func.size() != 1 || !this.isNumber((Term)func.get(0))) continue;
                        float sx = this.getNumber((Term)func.get(0));
                        ret.scale(sx, 1.0);
                        continue;
                    }
                    if (fname.equals("scaley")) {
                        if (func.size() != 1 || !this.isNumber((Term)func.get(0))) continue;
                        float sy = this.getNumber((Term)func.get(0));
                        ret.scale(1.0, sy);
                        continue;
                    }
                    if (fname.equals("skew")) {
                        if (func.size() == 1 && func.get(0) instanceof TermAngle) {
                            double ax = dec.getAngle((TermAngle)func.get(0));
                            ret.shear(Math.tan(ax), 0.0);
                            continue;
                        }
                        if (func.size() != 2 || !(func.get(0) instanceof TermAngle) || !(func.get(1) instanceof TermAngle)) continue;
                        double ax = dec.getAngle((TermAngle)func.get(0));
                        double ay = dec.getAngle((TermAngle)func.get(1));
                        ret.shear(Math.tan(ax), Math.tan(ay));
                        continue;
                    }
                    if (fname.equals("skewx")) {
                        if (func.size() != 1 || !(func.get(0) instanceof TermAngle)) continue;
                        double ax = dec.getAngle((TermAngle)func.get(0));
                        ret.shear(Math.tan(ax), 0.0);
                        continue;
                    }
                    if (fname.equals("skewy")) {
                        if (func.size() != 1 || !(func.get(0) instanceof TermAngle)) continue;
                        double ay = dec.getAngle((TermAngle)func.get(0));
                        ret.shear(0.0, Math.tan(ay));
                        continue;
                    }
                    if (!fname.equals("matrix") || func.size() != 6) continue;
                    double[] vals = new double[6];
                    boolean typesOk = true;
                    for (int i = 0; i < 6; ++i) {
                        if (this.isNumber((Term)func.get(i))) {
                            vals[i] = this.getNumber((Term)func.get(i));
                            continue;
                        }
                        typesOk = false;
                    }
                    if (!typesOk) continue;
                    ret.concatenate(new AffineTransform(vals));
                }
                ret.translate(-ox, -oy);
            }
            return ret;
        }
        return null;
    }

    private boolean isNumber(Term<?> term) {
        return term instanceof TermNumber || term instanceof TermInteger;
    }

    private float getNumber(Term<?> term) {
        if (term instanceof TermNumber) {
            return ((Float)((TermNumber)term).getValue()).floatValue();
        }
        return ((Float)((TermInteger)term).getValue()).floatValue();
    }
}

