/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.TermAngle;
import cz.vutbr.web.css.TermLengthOrPercent;
import java.awt.Rectangle;
import org.fit.cssbox.css.HTMLNorm;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.layout.VisualContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CSSDecoder {
    protected static final Logger log = LoggerFactory.getLogger(CSSDecoder.class);
    private VisualContext context;

    public CSSDecoder(VisualContext c) {
        this.context = c;
    }

    public VisualContext getContext() {
        return this.context;
    }

    public void setContext(VisualContext c) {
        this.context = c;
    }

    public int getLength(TermLengthOrPercent value, boolean auto, TermLengthOrPercent defval, TermLengthOrPercent autoval, int whole) {
        TermLengthOrPercent val = value;
        if (value == null) {
            val = defval;
        }
        if (auto) {
            val = autoval;
        }
        if (val != null) {
            return (int)this.context.pxLength(val, whole);
        }
        return 0;
    }

    public int getLength(TermLengthOrPercent value, boolean auto, int defval, int autoval, int whole) {
        if (auto) {
            return autoval;
        }
        if (value == null) {
            return defval;
        }
        return (int)this.context.pxLength(value, whole);
    }

    public double getAngle(TermAngle angle) {
        return this.context.radAngle(angle);
    }

    public static Rectangle computeReplacedObjectSize(ReplacedContent obj, ElementBox box) {
        int boxh;
        int boxw;
        float intr;
        int inth;
        int intw;
        if (obj != null) {
            intw = obj.getIntrinsicWidth();
            inth = obj.getIntrinsicHeight();
            if (intw == 0 || inth == 0) {
                log.warn("Obtained a zero intrinsic width or height for " + obj.toString());
                inth = 1;
                intw = 1;
            }
            intr = (float)intw / (float)inth;
            boxw = intw;
            boxh = inth;
        } else {
            intw = 20;
            boxw = 20;
            inth = 20;
            boxh = 20;
            intr = 1.0f;
        }
        Rectangle cb = box.getContainingBlock();
        Element el = box.getElement();
        int atrw = -1;
        int atrh = -1;
        try {
            if (!HTMLNorm.getAttribute(el, "width").equals("")) {
                atrw = HTMLNorm.computeAttributeLength(HTMLNorm.getAttribute(el, "width"), cb.width);
            }
        }
        catch (NumberFormatException e) {
            log.info("Invalid width value: " + HTMLNorm.getAttribute(el, "width"));
        }
        try {
            if (!HTMLNorm.getAttribute(el, "height").equals("")) {
                ElementBox cbox;
                for (cbox = box.getContainingBlockBox(); cbox != null && !cbox.hasFixedHeight() && !(cbox instanceof Viewport); cbox = cbox.getContainingBlockBox()) {
                }
                atrh = HTMLNorm.computeAttributeLength(HTMLNorm.getAttribute(el, "height"), ((Box)cbox).getContentHeight());
            }
        }
        catch (NumberFormatException e) {
            log.info("Invalid height value: " + HTMLNorm.getAttribute(el, "width"));
        }
        int twidth = cb.width;
        int theight = cb.height;
        CSSDecoder dec = new CSSDecoder(box.getVisualContext());
        CSSProperty.Width width = (CSSProperty.Width)box.getStyle().getProperty("width");
        TermLengthOrPercent vWidth = null;
        if (width == CSSProperty.Width.AUTO) {
            width = null;
        }
        if (width != null) {
            vWidth = box.getLengthValue("width");
        }
        CSSProperty.Height height = (CSSProperty.Height)box.getStyle().getProperty("height");
        TermLengthOrPercent vHeight = null;
        if (height == CSSProperty.Height.AUTO) {
            height = null;
        }
        if (height != null && (vHeight = box.getLengthValue("height")).isPercentage() && !box.getContainingBlockBox().hasFixedHeight()) {
            height = null;
        }
        if (width == null && height == null && atrw == -1 && atrh == -1) {
            int[] result = CSSDecoder.applyCombinedLimits(boxw, boxh, box, dec, twidth, theight);
            boxw = result[0];
            boxh = result[1];
        } else if (width == null && atrw == -1 && (height != null || atrh != -1)) {
            boxh = dec.getLength(vHeight, false, atrh, 0, theight);
            boxh = CSSDecoder.applyHeightLimits(boxh, box, dec, theight);
            boxw = Math.round(intr * (float)boxh);
            boxw = CSSDecoder.applyWidthLimits(boxw, box, dec, twidth);
        } else if ((width != null || atrw != -1) && height == null && atrh == -1) {
            boxw = dec.getLength(vWidth, false, atrw, 0, twidth);
            boxw = CSSDecoder.applyWidthLimits(boxw, box, dec, twidth);
            boxh = Math.round((float)boxw / intr);
            boxh = CSSDecoder.applyHeightLimits(boxh, box, dec, theight);
        } else {
            boxw = dec.getLength(vWidth, false, atrw, 0, twidth);
            boxw = CSSDecoder.applyWidthLimits(boxw, box, dec, twidth);
            boxh = dec.getLength(vHeight, false, atrh, 0, theight);
            boxh = CSSDecoder.applyHeightLimits(boxh, box, dec, theight);
        }
        return new Rectangle(boxw, boxh);
    }

    public static int applyWidthLimits(int width, ElementBox box, CSSDecoder dec, int twidth) {
        int minval;
        CSSProperty.MinWidth min;
        int maxval;
        CSSProperty.MaxWidth max;
        int ret = width;
        if (twidth < 0) {
            twidth = 0;
        }
        if ((max = (CSSProperty.MaxWidth)box.getStyle().getProperty("max-width")) != null && max != CSSProperty.MaxWidth.NONE && ret > (maxval = dec.getLength(box.getLengthValue("max-width"), false, -1, -1, twidth))) {
            ret = maxval;
        }
        if ((min = (CSSProperty.MinWidth)box.getStyle().getProperty("min-width")) != null && ret < (minval = dec.getLength(box.getLengthValue("min-width"), false, -1, -1, twidth))) {
            ret = minval;
        }
        return ret;
    }

    public static int applyHeightLimits(int height, ElementBox box, CSSDecoder dec, int theight) {
        int minval;
        TermLengthOrPercent val;
        CSSProperty.MinHeight min;
        int maxval;
        TermLengthOrPercent val2;
        int ret = height;
        ElementBox cbox = box.getContainingBlockBox();
        CSSProperty.MaxHeight max = (CSSProperty.MaxHeight)box.getStyle().getProperty("max-height");
        if (max != null && max != CSSProperty.MaxHeight.NONE && (val2 = box.getLengthValue("max-height")) != null && (!val2.isPercentage() || cbox.hasFixedHeight()) && ret > (maxval = dec.getLength(val2, false, -1, -1, theight))) {
            ret = maxval;
        }
        if ((min = (CSSProperty.MinHeight)box.getStyle().getProperty("min-height")) != null && (val = box.getLengthValue("min-height")) != null && (!val.isPercentage() || cbox.hasFixedHeight()) && ret < (minval = dec.getLength(box.getLengthValue("min-height"), false, -1, -1, theight))) {
            ret = minval;
        }
        return ret;
    }

    public static int[] applyCombinedLimits(int w, int h, ElementBox box, CSSDecoder dec, int twidth, int theight) {
        int reth;
        int retw;
        TermLengthOrPercent val;
        ElementBox cbox = box.getContainingBlockBox();
        CSSProperty.MinWidth pminw = (CSSProperty.MinWidth)box.getStyle().getProperty("min-width");
        CSSProperty.MaxWidth pmaxw = (CSSProperty.MaxWidth)box.getStyle().getProperty("max-width");
        CSSProperty.MinHeight pminh = (CSSProperty.MinHeight)box.getStyle().getProperty("min-height");
        CSSProperty.MaxHeight pmaxh = (CSSProperty.MaxHeight)box.getStyle().getProperty("max-height");
        int minw = pminw != null ? dec.getLength(box.getLengthValue("min-width"), false, 0, 0, twidth) : 0;
        int maxw = pmaxw != null && pmaxw != CSSProperty.MaxWidth.NONE ? Math.max(minw, dec.getLength(box.getLengthValue("max-width"), false, 0, 0, twidth)) : Integer.MAX_VALUE;
        int minh = pminh != null ? ((val = box.getLengthValue("min-height")) != null && (!val.isPercentage() || cbox.hasFixedHeight()) ? dec.getLength(val, false, 0, 0, theight) : 0) : 0;
        int maxh = pmaxh != null && pmaxh != CSSProperty.MaxHeight.NONE ? ((val = box.getLengthValue("max-height")) != null && (!val.isPercentage() || cbox.hasFixedHeight()) ? Math.max(minh, dec.getLength(val, false, 0, 0, theight)) : Integer.MAX_VALUE) : Integer.MAX_VALUE;
        float hwr = (float)h / (float)w;
        float whr = (float)w / (float)h;
        if (w > maxw && h < minh) {
            retw = maxw;
            reth = minh;
        } else if (w < minw && h > maxh) {
            retw = minw;
            reth = maxh;
        } else if (w < minw && h < minh) {
            if ((float)minw / (float)w > (float)minh / (float)h) {
                retw = minw;
                reth = Math.min(maxh, Math.round((float)minw * hwr));
            } else {
                retw = Math.min(maxw, Math.round((float)minh * whr));
                reth = minh;
            }
        } else if (w > maxw && h > maxh) {
            if ((float)maxw / (float)w > (float)maxh / (float)h) {
                retw = Math.max(minw, Math.round((float)maxh * whr));
                reth = maxh;
            } else {
                retw = maxw;
                reth = Math.max(minh, Math.round((float)maxw * hwr));
            }
        } else if (h < minh) {
            retw = Math.min(Math.round((float)minh * whr), maxw);
            reth = minh;
        } else if (h > maxh) {
            retw = Math.max(Math.round((float)maxh * whr), minw);
            reth = maxh;
        } else if (w < minw) {
            retw = minw;
            reth = Math.min(Math.round((float)minw * hwr), maxh);
        } else if (w > maxw) {
            retw = maxw;
            reth = Math.max(Math.round((float)maxw * hwr), minh);
        } else {
            retw = w;
            reth = h;
        }
        return new int[]{retw, reth};
    }
}

