/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.net.URL;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Node;

public abstract class Box {
    protected boolean rootelem;
    protected boolean isblock;
    protected boolean isempty;
    protected boolean displayed;
    protected boolean visible;
    protected boolean sticky;
    protected Node node;
    protected int order;
    protected Rectangle bounds;
    protected Rectangle absbounds;
    protected Viewport viewport;
    protected ElementBox parent;
    protected ElementBox cbox;
    protected BlockBox clipblock;
    protected ElementBox stackingParent;
    protected int availwidth;
    protected Graphics2D g;
    protected VisualContext ctx;
    protected URL base;
    protected boolean splitted;
    protected int splitid;
    protected Box rest;

    public Box(Node n, Graphics2D g, VisualContext ctx) {
        this.g = g;
        this.ctx = ctx;
        this.node = n;
        this.rootelem = false;
        this.isblock = false;
        this.isempty = true;
        this.sticky = false;
        this.bounds = new Rectangle();
        this.absbounds = new Rectangle();
        this.displayed = true;
        this.visible = true;
        this.splitted = false;
        this.splitid = 0;
        this.rest = null;
    }

    public void copyValues(Box src) {
        this.rootelem = src.rootelem;
        this.isblock = src.isblock;
        this.order = src.order;
        this.isempty = src.isempty;
        this.sticky = src.sticky;
        this.availwidth = src.availwidth;
        this.viewport = src.viewport;
        this.parent = src.parent;
        this.cbox = src.cbox;
        this.clipblock = src.clipblock;
        this.bounds = new Rectangle(src.bounds);
        this.absbounds = new Rectangle(src.absbounds);
        this.displayed = src.displayed;
        this.visible = src.visible;
        this.splitted = src.splitted;
        this.rest = src.rest;
    }

    protected void initBox() {
    }

    public void initSubtree() {
        this.initBox();
    }

    public void adoptParent(ElementBox parent) {
        if (parent instanceof BlockBox) {
            this.setContainingBlockBox(parent);
        } else {
            this.setContainingBlockBox(parent.getContainingBlockBox());
        }
        this.setParent(parent);
        this.setViewport(parent.getViewport());
        this.setClipBlock(parent.getClipBlock());
    }

    public Node getNode() {
        return this.node;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getSplitId() {
        return this.splitid;
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public VisualContext getVisualContext() {
        return this.ctx;
    }

    public boolean isRootElement() {
        return this.rootelem;
    }

    public void makeRoot() {
        this.rootelem = true;
    }

    public boolean isBlock() {
        return this.isblock;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public boolean isVisible() {
        return this.visible && this.clipblock.isVisible() && this.clipblock.getClippedContentBounds().intersects(this.getAbsoluteBounds());
    }

    public boolean isDeclaredVisible() {
        return this.visible;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public boolean isReplaced() {
        return false;
    }

    public abstract String getText();

    public abstract boolean isWhitespace();

    public abstract boolean collapsesSpaces();

    public abstract boolean preservesLineBreaks();

    public abstract boolean allowsWrapping();

    public abstract boolean canSplitInside();

    public abstract boolean canSplitBefore();

    public abstract boolean canSplitAfter();

    public abstract boolean startsWithWhitespace();

    public abstract boolean endsWithWhitespace();

    public abstract void setIgnoreInitialWhitespace(boolean var1);

    public void setPosition(int x, int y) {
        this.bounds.setLocation(x, y);
    }

    public void moveRight(int ofs) {
        this.bounds.x += ofs;
    }

    public void moveDown(int ofs) {
        this.bounds.y += ofs;
    }

    public void setSize(int w, int h) {
        this.bounds.setSize(w, h);
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Rectangle getAbsoluteBounds() {
        return this.absbounds;
    }

    public void clipAbsoluteBounds(Rectangle clip) {
        Rectangle inter = this.absbounds.intersection(clip);
        if (inter.width == 0 && inter.height == 0) {
            this.displayed = false;
        } else {
            this.absbounds = inter;
        }
    }

    public Rectangle getClippedBounds() {
        if (this.clipblock == null) {
            return this.getAbsoluteBounds();
        }
        return this.clipblock.getClippedContentBounds().intersection(this.getAbsoluteBounds());
    }

    public int getAvailableWidth() {
        return this.availwidth;
    }

    public void setAvailableWidth(int availw) {
        this.availwidth = availw;
    }

    public Rectangle getContainingBlock() {
        if (this.cbox instanceof Viewport) {
            Rectangle visible = ((Viewport)this.cbox).getVisibleRect();
            return new Rectangle(0, 0, visible.width, visible.height);
        }
        return this.cbox.getContentBounds();
    }

    public Rectangle getAbsoluteContainingBlock() {
        if (this.cbox instanceof Viewport) {
            Rectangle ab = this.cbox.getAbsoluteBounds();
            Rectangle visible = ((Viewport)this.cbox).getVisibleRect();
            return new Rectangle(ab.x, ab.y, visible.width, visible.height);
        }
        return this.cbox.getAbsoluteContentBounds();
    }

    public ElementBox getContainingBlockBox() {
        return this.cbox;
    }

    public void setContainingBlockBox(ElementBox box) {
        this.cbox = box;
    }

    public BlockBox getClipBlock() {
        return this.clipblock;
    }

    public void setClipBlock(BlockBox clipblock) {
        this.clipblock = clipblock;
    }

    public abstract int totalWidth();

    public abstract int totalHeight();

    public abstract int getAvailableContentWidth();

    public abstract int getContentX();

    public abstract int getAbsoluteContentX();

    public abstract int getContentY();

    public abstract int getAbsoluteContentY();

    public abstract int getContentWidth();

    public abstract int getContentHeight();

    public Rectangle getContentBounds() {
        return new Rectangle(this.getContentX(), this.getContentY(), this.getContentWidth(), this.getContentHeight());
    }

    public Rectangle getAbsoluteContentBounds() {
        return new Rectangle(this.getAbsoluteContentX(), this.getAbsoluteContentY(), this.getContentWidth(), this.getContentHeight());
    }

    public abstract int getMinimalWidth();

    public abstract int getMaximalWidth();

    public abstract Rectangle getMinimalAbsoluteBounds();

    public abstract boolean isInFlow();

    public abstract boolean hasFixedWidth();

    public abstract boolean hasFixedHeight();

    public abstract boolean containsFlow();

    public abstract boolean affectsDisplay();

    public Viewport getViewport() {
        return this.viewport;
    }

    public void setViewport(Viewport viewport) {
        this.viewport = viewport;
    }

    public ElementBox getParent() {
        return this.parent;
    }

    public void setParent(ElementBox parent) {
        this.parent = parent;
    }

    public ElementBox getStackingParent() {
        return this.stackingParent;
    }

    public void setStackingParent(ElementBox stackingParent) {
        this.stackingParent = stackingParent;
    }

    protected void updateStackingContexts() {
        if (this.parent != null) {
            this.stackingParent = this.parent.formsStackingContext() ? this.parent : this.parent.getStackingParent();
        }
    }

    public URL getBase() {
        return this.base;
    }

    public void setBase(URL base) {
        this.base = base;
    }

    protected Box getRest() {
        return this.rest;
    }

    public abstract boolean doLayout(int var1, boolean var2, boolean var3);

    public abstract void absolutePositions();

    public abstract void draw(DrawStage var1);

    public abstract void drawExtent(Graphics2D var1);

    protected Rectangle applyClip(Shape current, Rectangle newclip) {
        if (current == null) {
            return newclip;
        }
        if (current instanceof Rectangle) {
            return ((Rectangle)current).intersection(newclip);
        }
        return current.getBounds().intersection(newclip);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.order;
        result = 31 * result + this.splitid;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Box other = (Box)obj;
        if (this.order != other.order) {
            return false;
        }
        return this.splitid == other.splitid;
    }

    public static enum DrawStage {
        DRAW_NONINLINE,
        DRAW_FLOAT,
        DRAW_INLINE;

    }
}

