/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.css;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermNumeric;
import cz.vutbr.web.css.TermPercent;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLNorm {
    public static String getAttribute(Element el, String name) {
        return el.hasAttribute(name) ? el.getAttribute(name) : "";
    }

    public static void attributesToStyles(Node n, String tab_inh) {
        String itab = tab_inh;
        if (n.getNodeType() == 1) {
            String align;
            String border;
            Element el = (Element)n;
            String tagname = el.getTagName().toLowerCase();
            String attrs = "";
            if ((tagname.equals("table") || tagname.equals("th") || tagname.equals("td") || tagname.equals("body")) && el.getAttributes().getNamedItem("background") != null) {
                attrs = attrs + "background-image: url(" + el.getAttribute("background") + ");";
            }
            if ((tagname.equals("table") || tagname.equals("tr") || tagname.equals("th") || tagname.equals("td") || tagname.equals("body")) && el.getAttributes().getNamedItem("bgcolor") != null) {
                attrs = attrs + "background-color: " + el.getAttribute("bgcolor") + ";";
            }
            if (tagname.equals("table")) {
                border = "0";
                String frame = "void";
                String rules = "none";
                int cpadding = 0;
                int cspacing = 0;
                itab = "";
                if (el.getAttributes().getNamedItem("cellpadding") != null) {
                    try {
                        cpadding = Integer.parseInt(el.getAttribute("cellpadding"));
                        itab = itab + "padding: " + cpadding + "px; ";
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (el.getAttributes().getNamedItem("cellspacing") != null) {
                    try {
                        cspacing = Integer.parseInt(el.getAttribute("cellspacing"));
                        attrs = attrs + "border-spacing: " + cspacing + "px; ";
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (el.getAttributes().getNamedItem("border") != null && !(border = el.getAttribute("border")).equals("0")) {
                    frame = "border";
                    rules = "all";
                }
                if (el.getAttributes().getNamedItem("frame") != null) {
                    frame = el.getAttribute("frame").toLowerCase();
                }
                if (el.getAttributes().getNamedItem("rules") != null) {
                    rules = el.getAttribute("rules").toLowerCase();
                }
                if (!border.equals("0")) {
                    String fstyle = "border-@-style:solid;border-@-width:" + border + "px;";
                    if (frame.equals("above")) {
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "top");
                    }
                    if (frame.equals("below")) {
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "bottom");
                    }
                    if (frame.equals("hsides")) {
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "left");
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "right");
                    }
                    if (frame.equals("lhs")) {
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "left");
                    }
                    if (frame.equals("rhs")) {
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "right");
                    }
                    if (frame.equals("vsides")) {
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "top");
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "bottom");
                    }
                    if (frame.equals("box")) {
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "left");
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "right");
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "top");
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "bottom");
                    }
                    if (frame.equals("border")) {
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "left");
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "right");
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "top");
                        attrs = attrs + HTMLNorm.applyBorders(fstyle, "bottom");
                    }
                    fstyle = "border-@-style:solid;border-@-width:1px;";
                    if (rules.equals("rows")) {
                        itab = itab + HTMLNorm.applyBorders(fstyle, "top");
                        itab = itab + HTMLNorm.applyBorders(fstyle, "bottom");
                        attrs = attrs + "border-collapse:collapse;";
                    } else if (rules.equals("cols")) {
                        itab = itab + HTMLNorm.applyBorders(fstyle, "left");
                        itab = itab + HTMLNorm.applyBorders(fstyle, "right");
                        attrs = attrs + "border-collapse:collapse;";
                    } else if (rules.equals("all")) {
                        itab = itab + HTMLNorm.applyBorders(fstyle, "top");
                        itab = itab + HTMLNorm.applyBorders(fstyle, "bottom");
                        itab = itab + HTMLNorm.applyBorders(fstyle, "left");
                        itab = itab + HTMLNorm.applyBorders(fstyle, "right");
                    }
                }
            }
            if ((tagname.equals("th") || tagname.equals("td")) && itab.length() > 0) {
                attrs = itab + attrs;
            }
            if ((tagname.equals("img") || tagname.equals("object")) && el.getAttributes().getNamedItem("border") != null) {
                border = el.getAttribute("border");
                String fstyle = border.equals("0") ? "border-@-style:none;" : "border-@-style:solid;border-@-width:" + border + "px;";
                attrs = attrs + HTMLNorm.applyBorders(fstyle, "top");
                attrs = attrs + HTMLNorm.applyBorders(fstyle, "right");
                attrs = attrs + HTMLNorm.applyBorders(fstyle, "bottom");
                attrs = attrs + HTMLNorm.applyBorders(fstyle, "left");
            }
            if ((tagname.equals("img") || tagname.equals("object") || tagname.equals("applet") || tagname.equals("iframe") || tagname.equals("input")) && el.getAttributes().getNamedItem("align") != null) {
                align = el.getAttribute("align");
                if (align.equals("left")) {
                    attrs = attrs + "float:left;";
                } else if (align.equals("right")) {
                    attrs = attrs + "float:right;";
                }
            }
            if (tagname.equals("col") || tagname.equals("colgroup") || tagname.equals("tbody") || tagname.equals("td") || tagname.equals("tfoot") || tagname.equals("th") || tagname.equals("thead") || tagname.equals("tr")) {
                if (el.getAttributes().getNamedItem("align") != null) {
                    align = el.getAttribute("align");
                    if (align.equals("left")) {
                        attrs = attrs + "text-align:left;";
                    } else if (align.equals("right")) {
                        attrs = attrs + "text-align:right;";
                    } else if (align.equals("center")) {
                        attrs = attrs + "text-align:center;";
                    } else if (align.equals("justify")) {
                        attrs = attrs + "text-align:justify;";
                    }
                }
                if (el.getAttributes().getNamedItem("valign") != null) {
                    align = el.getAttribute("valign");
                    if (align.equals("top")) {
                        attrs = attrs + "vertical-align:top;";
                    } else if (align.equals("middle")) {
                        attrs = attrs + "vertical-align:middle;";
                    } else if (align.equals("bottom")) {
                        attrs = attrs + "vertical-align:bottom;";
                    } else if (align.equals("baseline")) {
                        attrs = attrs + "vertical-align:baseline;";
                    }
                }
            }
            if (tagname.equals("font")) {
                if (el.getAttributes().getNamedItem("color") != null) {
                    attrs = attrs + "color: " + el.getAttribute("color") + ";";
                }
                if (el.getAttributes().getNamedItem("face") != null) {
                    attrs = attrs + "font-family: " + el.getAttribute("face") + ";";
                }
                if (el.getAttributes().getNamedItem("size") != null) {
                    String sn;
                    String sz = el.getAttribute("size");
                    String ret = "normal";
                    if (sz.equals("1")) {
                        ret = "xx-small";
                    } else if (sz.equals("2")) {
                        ret = "x-small";
                    } else if (sz.equals("3")) {
                        ret = "small";
                    } else if (sz.equals("4")) {
                        ret = "normal";
                    } else if (sz.equals("5")) {
                        ret = "large";
                    } else if (sz.equals("6")) {
                        ret = "x-large";
                    } else if (sz.equals("7")) {
                        ret = "xx-large";
                    } else if (sz.startsWith("+")) {
                        sn = sz.substring(1);
                        if (sn.equals("1")) {
                            ret = "120%";
                        } else if (sn.equals("2")) {
                            ret = "140%";
                        } else if (sn.equals("3")) {
                            ret = "160%";
                        } else if (sn.equals("4")) {
                            ret = "180%";
                        } else if (sn.equals("5")) {
                            ret = "200%";
                        } else if (sn.equals("6")) {
                            ret = "210%";
                        } else if (sn.equals("7")) {
                            ret = "220%";
                        }
                    } else if (sz.startsWith("-")) {
                        sn = sz.substring(1);
                        if (sn.equals("1")) {
                            ret = "90%";
                        } else if (sn.equals("2")) {
                            ret = "80%";
                        } else if (sn.equals("3")) {
                            ret = "70%";
                        } else if (sn.equals("4")) {
                            ret = "60%";
                        } else if (sn.equals("5")) {
                            ret = "50%";
                        } else if (sn.equals("6")) {
                            ret = "40%";
                        } else if (sn.equals("7")) {
                            ret = "30%";
                        }
                    }
                    attrs = attrs + "font-size: " + ret;
                }
            }
            if (attrs.length() > 0) {
                el.setAttribute("XDefaultStyle", HTMLNorm.getAttribute(el, "XDefaultStyle") + ";" + attrs);
            }
        }
        NodeList child = n.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            HTMLNorm.attributesToStyles(child.item(i), itab);
        }
    }

    public static int computeAttributeLength(String value, int whole) throws NumberFormatException {
        String sval = value.trim().toLowerCase();
        if (sval.endsWith("%")) {
            double val = Double.parseDouble(sval.substring(0, sval.length() - 1));
            return (int)Math.round(val * (double)whole / 100.0);
        }
        if (sval.endsWith("px")) {
            return (int)Math.rint(Double.parseDouble(sval.substring(0, sval.length() - 2)));
        }
        return (int)Math.rint(Double.parseDouble(sval));
    }

    public static TermLengthOrPercent createLengthOrPercent(String spec) {
        if ((spec = spec.trim()).endsWith("%")) {
            try {
                float val = Float.parseFloat(spec.substring(0, spec.length() - 1));
                TermPercent perc = CSSFactory.getTermFactory().createPercent(Float.valueOf(val));
                return perc;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        try {
            float val = Float.parseFloat(spec);
            TermLength len = CSSFactory.getTermFactory().createLength(Float.valueOf(val), TermNumeric.Unit.px);
            return len;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String applyBorders(String template, String dir) {
        return template.replaceAll("@", dir);
    }

    public static void normalizeHTMLTree(Document doc) {
        NodeList tables = doc.getElementsByTagName("table");
        for (int i = 0; i < tables.getLength(); ++i) {
            Vector<Node> nodes = new Vector<Node>();
            HTMLNorm.recursiveFindBadNodesInTable(tables.item(i), null, nodes);
            for (Node n : nodes) {
                HTMLNorm.moveSubtreeBefore(n, tables.item(i));
            }
        }
    }

    private static void recursiveFindBadNodesInTable(Node n, Node cellroot, Vector<Node> nodes) {
        Node cell = cellroot;
        if (n.getNodeType() == 1) {
            String tag = n.getNodeName();
            if (tag.equalsIgnoreCase("table")) {
                if (cell != null) {
                    return;
                }
            } else if (!(tag.equalsIgnoreCase("tbody") || tag.equalsIgnoreCase("thead") || tag.equalsIgnoreCase("tfoot") || tag.equalsIgnoreCase("tr") || tag.equalsIgnoreCase("col") || tag.equalsIgnoreCase("colgroup"))) {
                if (tag.equalsIgnoreCase("td") || tag.equalsIgnoreCase("th") || tag.equalsIgnoreCase("caption")) {
                    cell = n;
                } else if (cell == null) {
                    nodes.add(n);
                    return;
                }
            }
        } else if (n.getNodeType() == 3 && cell == null && n.getNodeValue().trim().length() > 0) {
            nodes.add(n);
            return;
        }
        NodeList child = n.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            HTMLNorm.recursiveFindBadNodesInTable(child.item(i), cell, nodes);
        }
    }

    private static void moveSubtreeBefore(Node root, Node ref) {
        ref.getParentNode().insertBefore(root, ref);
    }
}

