/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa.output;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.rootdev.javardfa.ParserFactory;
import net.rootdev.javardfa.Setting;
import net.rootdev.javardfa.StatementSink;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class OGPReader
implements StatementSink {
    static final String NS = "http://opengraphprotocol.org/schema/";
    static final int NSlen = "http://opengraphprotocol.org/schema/".length();
    private String base;
    private final Map<String, String> content = new HashMap<String, String>();

    @Override
    public void start() {
    }

    @Override
    public void end() {
    }

    @Override
    public void addObject(String subject, String predicate, String object) {
        this.collect(subject, predicate, object);
    }

    @Override
    public void addLiteral(String subject, String predicate, String lex, String lang, String datatype) {
        this.collect(subject, predicate, lex);
    }

    @Override
    public void addPrefix(String prefix, String uri) {
    }

    @Override
    public void setBase(String base) {
        this.base = base;
    }

    private void collect(String subject, String predicate, String value) {
        if (!subject.equals(this.base)) {
            return;
        }
        if (predicate.startsWith(NS)) {
            this.content.put(predicate.substring(NSlen), value);
        } else {
            this.content.put(predicate, value);
        }
    }

    public Map<String, String> getContent() {
        return this.content;
    }

    public static Map<String, String> getOGP(String url, ParserFactory.Format format) throws SAXException, IOException {
        OGPReader reader = new OGPReader();
        XMLReader parser = ParserFactory.createReaderForFormat((StatementSink)reader, format, new Setting[0]);
        parser.parse(new InputSource(url));
        return reader.getContent();
    }
}

