/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import org.mabb.fontverter.io.DataTypeBindingDeserializer;
import org.mabb.fontverter.io.FontDataInput;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.opentype.OpenTypeFont;
import org.mabb.fontverter.opentype.OpenTypeTable;
import org.mabb.fontverter.opentype.SfntHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTypeParser {
    private static final Logger log = LoggerFactory.getLogger(OpenTypeFont.class);
    private OpenTypeFont font;
    private FontDataInput input;

    public OpenTypeFont parse(byte[] data) throws IOException, InstantiationException, IllegalAccessException {
        return this.parse(data, new OpenTypeFont());
    }

    public OpenTypeFont parse(byte[] data, OpenTypeFont font) throws IOException, InstantiationException, IllegalAccessException {
        this.font = font;
        this.input = new FontDataInputStream(data);
        DataTypeBindingDeserializer deserializer = new DataTypeBindingDeserializer();
        font.sfntHeader = (SfntHeader)deserializer.deserialize(this.input, (Object)new SfntHeader());
        this.readTableHeaderEntries();
        this.readTableDataEntries();
        return font;
    }

    private void readTableHeaderEntries() throws IllegalAccessException, InstantiationException, IOException {
        DataTypeBindingDeserializer deserializer = new DataTypeBindingDeserializer();
        for (int i = 0; i < this.font.sfntHeader.numTables; ++i) {
            OpenTypeTable.OtfTableRecord record = (OpenTypeTable.OtfTableRecord)deserializer.deserialize(this.input, OpenTypeTable.OtfTableRecord.class);
            OpenTypeTable table = OpenTypeTable.createFromRecord(record, this.font);
            table.isFromParsedFont = true;
            this.font.addTable(table);
        }
        this.font.orderTablesByDependencies();
    }

    private void readTableDataEntries() throws IOException {
        for (OpenTypeTable tableOn : this.font.getTables()) {
            this.input.seek((int)tableOn.getOffset());
            int dataReadLength = (int)tableOn.record.length;
            byte[] tableData = this.input.readBytes(dataReadLength);
            tableOn.readData(tableData);
        }
    }
}

