/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Converter;
import net.javacrumbs.jsonunit.core.internal.GenericNodeBuilder;
import net.javacrumbs.jsonunit.core.internal.JsonSource;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonUtils {
    private static final Converter converter = Converter.createDefaultConverter();

    public static Node convertToJson(@Nullable Object source, String label) {
        return JsonUtils.convertToJson(source, label, false);
    }

    public static Node convertToJson(@Nullable Object source, String label, boolean lenient) {
        if (source instanceof JsonSource) {
            return converter.convertToNode(((JsonSource)source).getJson(), label, lenient);
        }
        return converter.convertToNode(source, label, lenient);
    }

    @NotNull
    public static Node getNode(Object root, String path) {
        return JsonUtils.getNode(root, Path.create(path));
    }

    @NotNull
    public static Node getNode(Object root, Path path) {
        return path.getNode(JsonUtils.convertToJson(root, "actual"));
    }

    public static boolean nodeAbsent(Object json, String path, Configuration configuration) {
        return JsonUtils.nodeAbsent(json, Path.create(path), configuration);
    }

    public static boolean nodeAbsent(Object json, Path path, Configuration configuration) {
        return JsonUtils.nodeAbsent(json, path, configuration.getOptions().contains((Object)Option.TREATING_NULL_AS_ABSENT));
    }

    @NotNull
    public static Object jsonSource(Object json, String pathPrefix) {
        return JsonUtils.jsonSource(json, pathPrefix, Collections.emptyList());
    }

    @NotNull
    public static Object jsonSource(Object json, String pathPrefix, List<String> matchingPaths) {
        return new DefaultJsonSource(json, pathPrefix, matchingPaths);
    }

    @NotNull
    public static String getPathPrefix(Object json) {
        if (json instanceof JsonSource) {
            return ((JsonSource)json).getPathPrefix();
        }
        return "";
    }

    static boolean nodeAbsent(Object json, Path path, boolean treatNullAsAbsent) {
        Node node = JsonUtils.getNode(json, path);
        if (node.isNull()) {
            return treatNullAsAbsent;
        }
        return node.isMissingNode();
    }

    static String quoteIfNeeded(String source) {
        String trimmed = source.trim();
        if (JsonUtils.isObject(trimmed) || JsonUtils.isArray(trimmed) || JsonUtils.isString(trimmed) || JsonUtils.isBoolean(trimmed) || JsonUtils.isNull(trimmed) || JsonUtils.isNumber(trimmed)) {
            return source;
        }
        return "\"" + source + "\"";
    }

    static Object quoteIfNeeded(Object source) {
        if (source instanceof String) {
            return JsonUtils.quoteIfNeeded((String)source);
        }
        return source;
    }

    public static Node wrapDeserializedObject(Object source) {
        return GenericNodeBuilder.wrapDeserializedObject(source);
    }

    public static Object missingNode() {
        return Node.MISSING_NODE;
    }

    private static boolean isNull(String trimmed) {
        return trimmed.equals("null");
    }

    private static boolean isBoolean(String trimmed) {
        return trimmed.equals("true") || trimmed.equals("false");
    }

    private static boolean isString(String trimmed) {
        return trimmed.startsWith("\"");
    }

    private static boolean isArray(String trimmed) {
        return trimmed.startsWith("[");
    }

    private static boolean isObject(String trimmed) {
        return trimmed.startsWith("{");
    }

    private static boolean isNumber(String source) {
        try {
            Double.parseDouble(source);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    static String prettyPrint(Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        Iterator entries = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).iterator();
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry)entries.next();
            builder.append('\"').append((String)entry.getKey()).append('\"').append(":");
            JsonUtils.appendQuoteString(entry.getValue(), builder);
            if (!entries.hasNext()) continue;
            builder.append(",");
        }
        builder.append("}");
        return builder.toString();
    }

    private static void appendQuoteString(Object value, StringBuilder builder) {
        if (value instanceof String) {
            builder.append("\"").append(value).append("\"");
        } else {
            builder.append(value);
        }
    }

    private static class DefaultJsonSource
    implements JsonSource {
        private final Object json;
        private final String pathPrefix;
        private final List<String> matchingPaths;

        public DefaultJsonSource(Object json, String pathPrefix, List<String> matchingPaths) {
            this.json = json;
            this.pathPrefix = pathPrefix;
            this.matchingPaths = matchingPaths;
        }

        @Override
        public Object getJson() {
            return this.json;
        }

        @Override
        public String getPathPrefix() {
            return this.pathPrefix;
        }

        @Override
        public List<String> getMatchingPaths() {
            return this.matchingPaths;
        }

        public String toString() {
            return "JSON in path \"" + this.pathPrefix + "\"";
        }
    }
}

