/*
 * Decompiled with CFR 0.152.
 */
package scala_maven_executions;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.util.StringUtils;
import scala_maven_executions.JavaMainCallerSupport;
import scala_maven_executions.LogProcessorUtils;
import scala_maven_executions.MainHelper;
import scala_maven_executions.MainWithArgsInFile;
import scala_maven_executions.SpawnMonitor;
import util.JavaLocator;

public class JavaMainCallerByFork
extends JavaMainCallerSupport {
    private boolean _forceUseArgFile;
    private String _javaExec;
    private boolean _redirectToLog;

    public JavaMainCallerByFork(AbstractMojo requester1, String mainClassName1, String classpath, String[] jvmArgs1, String[] args1, boolean forceUseArgFile, Toolchain toolchain) {
        super(requester1, mainClassName1, classpath, jvmArgs1, args1);
        for (String key : System.getenv().keySet()) {
            this.env.add(key + "=" + System.getenv(key));
        }
        this._javaExec = JavaLocator.findExecutableFromToolchain(toolchain);
        this._forceUseArgFile = forceUseArgFile;
    }

    @Override
    public boolean run(boolean displayCmd, boolean throwFailure) throws Exception {
        List<String> cmd = this.buildCommand();
        this.displayCmd(displayCmd, cmd);
        DefaultExecutor exec = new DefaultExecutor();
        if (!this._redirectToLog) {
            exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err, System.in));
        } else {
            exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)new LogOutputStream(){
                private LogProcessorUtils.LevelState _previous = new LogProcessorUtils.LevelState();

                protected void processLine(String line, int level) {
                    try {
                        this._previous = LogProcessorUtils.levelStateOf(line, this._previous);
                        switch (this._previous.level) {
                            case ERROR: {
                                JavaMainCallerByFork.this.requester.getLog().error((CharSequence)line);
                                break;
                            }
                            case WARNING: {
                                JavaMainCallerByFork.this.requester.getLog().warn((CharSequence)line);
                                break;
                            }
                            default: {
                                JavaMainCallerByFork.this.requester.getLog().info((CharSequence)line);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }));
        }
        CommandLine cl = new CommandLine(cmd.get(0));
        for (int i = 1; i < cmd.size(); ++i) {
            cl.addArgument(cmd.get(i), false);
        }
        try {
            int exitValue = exec.execute(cl);
            if (exitValue != 0) {
                if (throwFailure) {
                    throw new MojoFailureException("command line returned non-zero value:" + exitValue);
                }
                return false;
            }
            if (!displayCmd) {
                this.tryDeleteArgFile(cmd);
            }
            return true;
        }
        catch (ExecuteException exc) {
            if (throwFailure) {
                throw exc;
            }
            return false;
        }
    }

    @Override
    public SpawnMonitor spawn(boolean displayCmd) throws Exception {
        List<String> cmd = this.buildCommand();
        File out = new File(System.getProperty("java.io.tmpdir"), this.mainClassName + ".out");
        out.delete();
        cmd.add(">" + out.getCanonicalPath());
        File err = new File(System.getProperty("java.io.tmpdir"), this.mainClassName + ".err");
        err.delete();
        cmd.add("2>" + err.getCanonicalPath());
        ArrayList<String> cmd2 = new ArrayList<String>();
        if (OS.isFamilyDOS()) {
            cmd2.add("cmd.exe");
            cmd2.add("/C");
            cmd2.addAll(cmd);
        } else {
            cmd2.add("/bin/sh");
            cmd2.add("-c");
            cmd2.addAll(cmd);
        }
        this.displayCmd(displayCmd, cmd2);
        ProcessBuilder pb = new ProcessBuilder(cmd2);
        Process p = pb.start();
        return () -> {
            try {
                p.exitValue();
                return false;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        };
    }

    private void displayCmd(boolean displayCmd, List<String> cmd) {
        if (displayCmd) {
            this.requester.getLog().info((CharSequence)("cmd:  " + StringUtils.join(cmd.iterator(), (String)" ")));
        } else if (this.requester.getLog().isDebugEnabled()) {
            this.requester.getLog().debug((CharSequence)("cmd:  " + StringUtils.join(cmd.iterator(), (String)" ")));
        }
    }

    private List<String> buildCommand() throws Exception {
        ArrayList<String> back = new ArrayList<String>(2 + this.jvmArgs.size() + this.args.size());
        back.add(this._javaExec);
        if (!this._forceUseArgFile && this.lengthOf(this.args, 1L) + this.lengthOf(this.jvmArgs, 1L) < 400L) {
            back.addAll(this.jvmArgs);
            back.add(this.mainClassName);
            back.addAll(this.args);
        } else {
            File jarPath = new File(MainHelper.locateJar(MainHelper.class));
            this.requester.getLog().debug((CharSequence)("plugin jar to add :" + jarPath));
            this.addToClasspath(jarPath);
            back.addAll(this.jvmArgs);
            back.add(MainWithArgsInFile.class.getName());
            back.add(this.mainClassName);
            back.add(MainHelper.createArgFile(this.args).getCanonicalPath());
        }
        return back;
    }

    private void tryDeleteArgFile(List<String> cmd) {
        File f;
        String last = cmd.get(cmd.size() - 1);
        if (last.endsWith(".args") && (f = new File(last)).exists() && f.getName().startsWith("scala-maven-")) {
            f.delete();
        }
    }

    private long lengthOf(List<String> l, long sepLength) {
        long back = 0L;
        for (String str : l) {
            back += (long)str.length() + sepLength;
        }
        return back;
    }

    @Override
    public void redirectToLog() {
        this._redirectToLog = true;
    }
}

