/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.PartialFunction;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.AbstractQueue;
import io.vavr.collection.Collections;
import io.vavr.collection.Comparators;
import io.vavr.collection.Iterator;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Ordered;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

@Deprecated
public final class PriorityQueue<T>
extends AbstractQueue<T, PriorityQueue<T>>
implements Serializable,
Ordered<T> {
    private static final long serialVersionUID = 1L;
    private final Comparator<? super T> comparator;
    private final Seq<Node<T>> forest;
    private final int size;

    private PriorityQueue(Comparator<? super T> comparator, Seq<Node<T>> forest, int size) {
        this.comparator = comparator;
        this.forest = forest;
        this.size = size;
    }

    private PriorityQueue<T> with(Seq<Node<T>> forest, int size) {
        return new PriorityQueue<T>(this.comparator, forest, size);
    }

    @Override
    public <R> PriorityQueue<R> collect(PartialFunction<? super T, ? extends R> partialFunction) {
        return PriorityQueue.ofAll(Comparators.naturalComparator(), this.iterator().collect(partialFunction));
    }

    @Override
    public PriorityQueue<T> enqueue(T element) {
        Seq<Node<T>> result = PriorityQueue.insert(this.comparator, element, this.forest);
        return this.with(result, this.size + 1);
    }

    @Override
    public PriorityQueue<T> enqueueAll(Iterable<? extends T> elements) {
        return this.merge(PriorityQueue.ofAll(this.comparator, elements));
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty " + this.stringPrefix());
        }
        return PriorityQueue.findMin(this.comparator, this.forest).root;
    }

    @Override
    public PriorityQueue<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty " + this.stringPrefix());
        }
        return (PriorityQueue)this.dequeue()._2;
    }

    @Override
    public Tuple2<T, PriorityQueue<T>> dequeue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("dequeue of empty " + this.stringPrefix());
        }
        Tuple2<? super T, Seq<Node<? super T>>> dequeue = PriorityQueue.deleteMin(this.comparator, this.forest);
        return Tuple.of(dequeue._1, this.with((Seq)dequeue._2, this.size - 1));
    }

    public PriorityQueue<T> merge(PriorityQueue<T> target) {
        Seq<Node<T>> meld = PriorityQueue.meld(this.comparator, this.forest, target.forest);
        return this.with(meld, this.size + target.size);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    public static <T extends Comparable<? super T>> PriorityQueue<T> empty() {
        return PriorityQueue.empty(Comparators.naturalComparator());
    }

    public static <T> PriorityQueue<T> empty(Comparator<? super T> comparator) {
        return new PriorityQueue<T>(comparator, List.empty(), 0);
    }

    public static <T> Collector<T, ArrayList<T>, PriorityQueue<T>> collector() {
        return Collections.toListAndThen(values -> PriorityQueue.ofAll(Comparators.naturalComparator(), values));
    }

    public static <T> PriorityQueue<T> narrow(PriorityQueue<? extends T> queue) {
        return queue;
    }

    public static <T extends Comparable<? super T>> PriorityQueue<T> of(T element) {
        return PriorityQueue.of(Comparators.naturalComparator(), element);
    }

    public static <T extends Comparable<? super T>> PriorityQueue<T> of(T ... elements) {
        return PriorityQueue.ofAll(Comparators.naturalComparator(), List.of(elements));
    }

    public static <T> PriorityQueue<T> of(Comparator<? super T> comparator, T element) {
        return PriorityQueue.ofAll(comparator, List.of(element));
    }

    public static <T> PriorityQueue<T> of(Comparator<? super T> comparator, T ... elements) {
        return PriorityQueue.ofAll(comparator, List.of(elements));
    }

    public static <T extends Comparable<? super T>> PriorityQueue<T> ofAll(Iterable<? extends T> elements) {
        return PriorityQueue.ofAll(Comparators.naturalComparator(), elements);
    }

    public static <T> PriorityQueue<T> ofAll(Comparator<? super T> comparator, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof PriorityQueue && ((PriorityQueue)elements).comparator == comparator) {
            return (PriorityQueue)elements;
        }
        int size = 0;
        Seq<Node<Object>> forest = List.empty();
        for (T value : elements) {
            forest = PriorityQueue.insert(comparator, value, forest);
            ++size;
        }
        return new PriorityQueue<T>(comparator, forest, size);
    }

    public static <T extends Comparable<? super T>> PriorityQueue<T> ofAll(Stream<? extends T> javaStream) {
        return PriorityQueue.ofAll(Comparators.naturalComparator(), Iterator.ofAll(javaStream.iterator()));
    }

    public static <T> PriorityQueue<T> ofAll(Comparator<? super T> comparator, Stream<? extends T> javaStream) {
        return PriorityQueue.ofAll(comparator, Iterator.ofAll(javaStream.iterator()));
    }

    public static <T> PriorityQueue<T> tabulate(int size, Function<? super Integer, ? extends T> function) {
        Objects.requireNonNull(function, "function is null");
        Comparator comparator = Comparators.naturalComparator();
        return Collections.tabulate(size, function, PriorityQueue.empty(comparator), values -> PriorityQueue.ofAll(comparator, List.of(values)));
    }

    public static <T> PriorityQueue<T> fill(int size, Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        Comparator comparator = Comparators.naturalComparator();
        return Collections.fill(size, supplier, PriorityQueue.empty(comparator), values -> PriorityQueue.ofAll(comparator, List.of(values)));
    }

    public static <T> PriorityQueue<T> fill(int size, T element) {
        Comparator comparator = Comparators.naturalComparator();
        return Collections.fillObject(size, element, PriorityQueue.empty(comparator), values -> PriorityQueue.ofAll(comparator, List.of(values)));
    }

    @Override
    public List<T> toList() {
        LinearSeq results = List.empty();
        PriorityQueue queue = this;
        while (!queue.isEmpty()) {
            Tuple2<T, PriorityQueue<T>> dequeue = queue.dequeue();
            results = results.prepend(dequeue._1);
            queue = (PriorityQueue)dequeue._2;
        }
        return results.reverse();
    }

    public final <U> U transform(Function<? super PriorityQueue<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @Override
    public PriorityQueue<T> distinct() {
        return this.distinctBy((Comparator)this.comparator);
    }

    @Override
    public PriorityQueue<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.isEmpty() ? this : PriorityQueue.ofAll(comparator, this.iterator().distinctBy(comparator));
    }

    @Override
    public <U> PriorityQueue<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        return this.isEmpty() ? this : PriorityQueue.ofAll(this.comparator, this.iterator().distinctBy(keyExtractor));
    }

    @Override
    public PriorityQueue<T> drop(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this;
        }
        if (n >= this.length()) {
            return PriorityQueue.empty(this.comparator);
        }
        return PriorityQueue.ofAll(this.comparator, this.iterator().drop(n));
    }

    @Override
    public PriorityQueue<T> dropRight(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this;
        }
        if (n >= this.length()) {
            return PriorityQueue.empty(this.comparator);
        }
        return PriorityQueue.ofAll(this.comparator, this.iterator().dropRight(n));
    }

    @Override
    public PriorityQueue<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        AbstractQueue result = this;
        while (!result.isEmpty() && predicate.test(result.head())) {
            result = result.tail();
        }
        return result;
    }

    @Override
    public PriorityQueue<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return this;
        }
        return PriorityQueue.ofAll(this.comparator, this.iterator().filter(predicate));
    }

    @Override
    public <U> PriorityQueue<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        return this.flatMap(Comparators.naturalComparator(), mapper);
    }

    public <U> PriorityQueue<U> flatMap(Comparator<U> comparator, Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return PriorityQueue.ofAll(comparator, this.iterator().flatMap(mapper));
    }

    @Override
    public <U> U foldRight(U zero, BiFunction<? super T, ? super U, ? extends U> accumulator) {
        Objects.requireNonNull(zero, "zero is null");
        Objects.requireNonNull(accumulator, "accumulator is null");
        return this.toList().foldRight(zero, accumulator);
    }

    @Override
    public <C> Map<C, ? extends PriorityQueue<T>> groupBy(Function<? super T, ? extends C> classifier) {
        return Collections.groupBy(this, classifier, elements -> PriorityQueue.ofAll(this.comparator, elements));
    }

    @Override
    public Iterator<? extends PriorityQueue<T>> grouped(int size) {
        return this.sliding(size, size);
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public PriorityQueue<T> init() {
        return PriorityQueue.ofAll(this.comparator, this.iterator().init());
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public T last() {
        return Collections.last(this);
    }

    @Override
    public int length() {
        return this.size;
    }

    @Override
    public <U> PriorityQueue<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.map(Comparators.naturalComparator(), mapper);
    }

    public <U> PriorityQueue<U> map(Comparator<U> comparator, Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return PriorityQueue.ofAll(comparator, this.iterator().map(mapper));
    }

    @Override
    public PriorityQueue<T> orElse(Iterable<? extends T> other) {
        return this.isEmpty() ? PriorityQueue.ofAll(this.comparator, other) : this;
    }

    @Override
    public PriorityQueue<T> orElse(Supplier<? extends Iterable<? extends T>> supplier) {
        return this.isEmpty() ? PriorityQueue.ofAll(this.comparator, supplier.get()) : this;
    }

    @Override
    public Tuple2<? extends PriorityQueue<T>, ? extends PriorityQueue<T>> partition(Predicate<? super T> predicate) {
        AbstractQueue left;
        Objects.requireNonNull(predicate, "predicate is null");
        AbstractQueue right = left = PriorityQueue.empty(this.comparator);
        for (Object t : this) {
            if (predicate.test(t)) {
                left = left.enqueue(t);
                continue;
            }
            right = right.enqueue(t);
        }
        return Tuple.of(left, right);
    }

    @Override
    public PriorityQueue<T> replace(T currentElement, T newElement) {
        Objects.requireNonNull(currentElement, "currentElement is null");
        Objects.requireNonNull(newElement, "newElement is null");
        return PriorityQueue.ofAll(this.comparator, this.iterator().replace(currentElement, newElement));
    }

    @Override
    public PriorityQueue<T> replaceAll(T currentElement, T newElement) {
        Objects.requireNonNull(currentElement, "currentElement is null");
        Objects.requireNonNull(newElement, "newElement is null");
        return PriorityQueue.ofAll(this.comparator, this.iterator().replaceAll(currentElement, newElement));
    }

    @Override
    public PriorityQueue<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
        return Collections.scanLeft(this, zero, operation, it -> PriorityQueue.ofAll(this.comparator, it));
    }

    @Override
    public <U> PriorityQueue<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        return Collections.scanLeft(this, zero, operation, it -> PriorityQueue.ofAll(Comparators.naturalComparator(), it));
    }

    @Override
    public <U> PriorityQueue<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        return Collections.scanRight(this, zero, operation, it -> PriorityQueue.ofAll(Comparators.naturalComparator(), it));
    }

    @Override
    public Iterator<? extends PriorityQueue<T>> slideBy(Function<? super T, ?> classifier) {
        return this.iterator().slideBy(classifier).map((T v) -> PriorityQueue.ofAll(this.comparator, v));
    }

    @Override
    public Iterator<? extends PriorityQueue<T>> sliding(int size) {
        return this.iterator().sliding(size).map((T v) -> PriorityQueue.ofAll(this.comparator, v));
    }

    @Override
    public Iterator<? extends PriorityQueue<T>> sliding(int size, int step) {
        return this.iterator().sliding(size, step).map((T v) -> PriorityQueue.ofAll(this.comparator, v));
    }

    @Override
    public Tuple2<? extends PriorityQueue<T>, ? extends PriorityQueue<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Tuple.of(this.takeWhile((Predicate)predicate), this.dropWhile((Predicate)predicate));
    }

    @Override
    public PriorityQueue<T> take(int n) {
        if (n >= this.size() || this.isEmpty()) {
            return this;
        }
        if (n <= 0) {
            return PriorityQueue.empty(this.comparator);
        }
        return PriorityQueue.ofAll(this.comparator, this.iterator().take(n));
    }

    @Override
    public PriorityQueue<T> takeRight(int n) {
        if (n >= this.size() || this.isEmpty()) {
            return this;
        }
        if (n <= 0) {
            return PriorityQueue.empty(this.comparator);
        }
        return PriorityQueue.ofAll(this.comparator, this.toArray().takeRight(n));
    }

    @Override
    public PriorityQueue<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.isEmpty() ? this : PriorityQueue.ofAll(this.comparator, this.iterator().takeUntil(predicate));
    }

    @Override
    public <U> PriorityQueue<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        return PriorityQueue.ofAll(Tuple2.comparator(this.comparator(), Comparators.naturalComparator()), this.iterator().zipWith(that, Tuple::of));
    }

    @Override
    public <U, R> PriorityQueue<R> zipWith(Iterable<? extends U> that, BiFunction<? super T, ? super U, ? extends R> mapper) {
        Objects.requireNonNull(that, "that is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return PriorityQueue.ofAll(Comparators.naturalComparator(), this.iterator().zipWith(that, mapper));
    }

    @Override
    public <U> PriorityQueue<Tuple2<T, U>> zipAll(Iterable<? extends U> that, T thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        return PriorityQueue.ofAll(Tuple2.comparator(this.comparator(), Comparators.naturalComparator()), this.iterator().zipAll(that, thisElem, thatElem));
    }

    @Override
    public PriorityQueue<Tuple2<T, Integer>> zipWithIndex() {
        return PriorityQueue.ofAll(Tuple2.comparator(this.comparator(), Comparators.naturalComparator()), this.iterator().zipWithIndex(Tuple::of));
    }

    @Override
    public <U> PriorityQueue<U> zipWithIndex(BiFunction<? super T, ? super Integer, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return PriorityQueue.ofAll(Comparators.naturalComparator(), this.iterator().zipWithIndex(mapper));
    }

    @Override
    public String stringPrefix() {
        return "PriorityQueue";
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof PriorityQueue && Collections.areEqual(this, (Iterable)o);
    }

    @Override
    public int hashCode() {
        return Collections.hashOrdered(this);
    }

    @Override
    public Comparator<T> comparator() {
        return this.comparator;
    }

    static <T> Tuple2<T, Seq<Node<T>>> deleteMin(Comparator<? super T> comparator, Seq<Node<T>> forest) {
        Node<? super T> minTree = PriorityQueue.findMin(comparator, forest);
        Seq<Node<T>> forestTail = minTree == forest.head() ? forest.tail() : forest.remove(minTree);
        Seq<Node<T>> newForest = PriorityQueue.rebuild(comparator, minTree.children);
        return Tuple.of(minTree.root, PriorityQueue.meld(comparator, newForest, forestTail));
    }

    static <T> Seq<Node<T>> insert(Comparator<? super T> comparator, T element, Seq<Node<T>> forest) {
        Node<Object> tree = Node.of(element, 0, List.empty());
        if (forest.size() >= 2) {
            Traversable tail = forest.tail();
            Node t1 = (Node)forest.head();
            Node t2 = (Node)tail.head();
            if (t1.rank == t2.rank) {
                return tree.skewLink(comparator, t1, t2).appendTo((Seq<Node<T>>)tail.tail());
            }
        }
        return tree.appendTo(forest);
    }

    static <T> Seq<Node<T>> meld(Comparator<? super T> comparator, Seq<Node<T>> source, Seq<Node<T>> target) {
        return PriorityQueue.meldUnique(comparator, PriorityQueue.uniqify(comparator, source), PriorityQueue.uniqify(comparator, target));
    }

    static <T> Node<T> findMin(Comparator<? super T> comparator, Seq<Node<T>> forest) {
        java.util.Iterator iterator = forest.iterator();
        Node min = (Node)iterator.next();
        java.util.Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            Node node = (Node)iterator2.next();
            if (comparator.compare(node.root, min.root) >= 0) continue;
            min = node;
        }
        return min;
    }

    private static <T> Seq<Node<T>> rebuild(Comparator<? super T> comparator, Seq<Node<T>> forest) {
        Seq<Node<T>> nonZeroRank = List.empty();
        Seq<Node<Object>> zeroRank = List.empty();
        while (!forest.isEmpty()) {
            Node initialForestHead = (Node)forest.head();
            if (initialForestHead.rank == 0) {
                zeroRank = PriorityQueue.insert(comparator, initialForestHead.root, zeroRank);
            } else {
                nonZeroRank = initialForestHead.appendTo(nonZeroRank);
            }
            forest = forest.tail();
        }
        return PriorityQueue.meld(comparator, nonZeroRank, zeroRank);
    }

    private static <T> Seq<Node<T>> uniqify(Comparator<? super T> comparator, Seq<Node<T>> forest) {
        return forest.isEmpty() ? forest : PriorityQueue.ins(comparator, (Node)forest.head(), forest.tail());
    }

    private static <T> Seq<Node<T>> ins(Comparator<? super T> comparator, Node<T> tree, Seq<Node<T>> forest) {
        while (!forest.isEmpty() && tree.rank == ((Node)forest.head()).rank) {
            tree = tree.link(comparator, (Node)forest.head());
            forest = forest.tail();
        }
        return tree.appendTo((Seq<Node<Object>>)forest);
    }

    private static <T> Seq<Node<T>> meldUnique(Comparator<? super T> comparator, Seq<Node<T>> forest1, Seq<Node<T>> forest2) {
        if (forest1.isEmpty()) {
            return forest2;
        }
        if (forest2.isEmpty()) {
            return forest1;
        }
        Node tree1 = (Node)forest1.head();
        Node tree2 = (Node)forest2.head();
        if (tree1.rank == tree2.rank) {
            Node<? super T> tree = tree1.link(comparator, tree2);
            Seq<Node<T>> forest = PriorityQueue.meldUnique(comparator, forest1.tail(), forest2.tail());
            return PriorityQueue.ins(comparator, tree, forest);
        }
        if (tree1.rank < tree2.rank) {
            Seq forest = PriorityQueue.meldUnique(comparator, forest1.tail(), forest2);
            return tree1.appendTo(forest);
        }
        Seq forest = PriorityQueue.meldUnique(comparator, forest1, forest2.tail());
        return tree2.appendTo(forest);
    }

    static final class Node<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final T root;
        final int rank;
        final Seq<Node<T>> children;

        private Node(T root, int rank, Seq<Node<T>> children) {
            this.root = root;
            this.rank = rank;
            this.children = children;
        }

        static <T> Node<T> of(T value, int rank, Seq<Node<T>> children) {
            return new Node<T>(value, rank, children);
        }

        Node<T> link(Comparator<? super T> comparator, Node<T> tree) {
            return comparator.compare(this.root, tree.root) <= 0 ? Node.of(this.root, this.rank + 1, tree.appendTo(this.children)) : Node.of(tree.root, tree.rank + 1, this.appendTo(tree.children));
        }

        Node<T> skewLink(Comparator<? super T> comparator, Node<T> left, Node<T> right) {
            if (comparator.compare(left.root, this.root) <= 0 && comparator.compare(left.root, right.root) <= 0) {
                return Node.of(left.root, left.rank + 1, this.appendTo(right.appendTo(left.children)));
            }
            if (comparator.compare(right.root, this.root) <= 0) {
                return Node.of(right.root, right.rank + 1, this.appendTo(left.appendTo(right.children)));
            }
            return Node.of(this.root, left.rank + 1, List.of(left, right));
        }

        Seq<Node<T>> appendTo(Seq<Node<T>> forest) {
            return forest.prepend(this);
        }
    }
}

