/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.Array;
import io.vavr.collection.Iterator;
import io.vavr.collection.Seq;
import java.util.NoSuchElementException;

final class GroupedIterator<T>
implements Iterator<Seq<T>> {
    private final Iterator<T> that;
    private final int size;
    private final int step;
    private final int gap;
    private final int preserve;
    private Object[] buffer;

    GroupedIterator(Iterator<T> that, int size, int step) {
        if (size < 1 || step < 1) {
            throw new IllegalArgumentException("size (" + size + ") and step (" + step + ") must both be positive");
        }
        this.that = that;
        this.size = size;
        this.step = step;
        this.gap = Math.max(step - size, 0);
        this.preserve = Math.max(size - step, 0);
        this.buffer = GroupedIterator.take(that, new Object[size], 0, size);
    }

    @Override
    public boolean hasNext() {
        return this.buffer.length > 0;
    }

    @Override
    public Seq<T> next() {
        if (this.buffer.length == 0) {
            throw new NoSuchElementException();
        }
        Object[] result = this.buffer;
        if (this.that.hasNext()) {
            this.buffer = new Object[this.size];
            if (this.preserve > 0) {
                System.arraycopy(result, this.step, this.buffer, 0, this.preserve);
            }
            if (this.gap > 0) {
                GroupedIterator.drop(this.that, this.gap);
                this.buffer = GroupedIterator.take(this.that, this.buffer, this.preserve, this.size);
            } else {
                this.buffer = GroupedIterator.take(this.that, this.buffer, this.preserve, this.step);
            }
        } else {
            this.buffer = new Object[0];
        }
        return Array.wrap(result);
    }

    @Override
    public String toString() {
        return "GroupedIterator";
    }

    private static void drop(Iterator<?> source, int count) {
        for (int i = 0; i < count && source.hasNext(); ++i) {
            source.next();
        }
    }

    private static Object[] take(Iterator<?> source, Object[] target, int offset, int count) {
        int i;
        for (i = offset; i < count + offset && source.hasNext(); ++i) {
            target[i] = source.next();
        }
        if (i < target.length) {
            Object[] result = new Object[i];
            System.arraycopy(target, 0, result, 0, i);
            return result;
        }
        return target;
    }
}

