/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.Iterator;
import io.vavr.collection.Set;
import java.util.NoSuchElementException;
import java.util.function.Function;

final class DistinctIterator<T, U>
implements Iterator<T> {
    private final Iterator<? extends T> that;
    private Set<U> known;
    private final Function<? super T, ? extends U> keyExtractor;
    private boolean nextDefined = false;
    private T next;

    DistinctIterator(Iterator<? extends T> that, Set<U> set, Function<? super T, ? extends U> keyExtractor) {
        this.that = that;
        this.known = set;
        this.keyExtractor = keyExtractor;
    }

    @Override
    public boolean hasNext() {
        return this.nextDefined || this.searchNext();
    }

    private boolean searchNext() {
        while (this.that.hasNext()) {
            Object elem = this.that.next();
            U key = this.keyExtractor.apply(elem);
            if (this.known.contains(key)) continue;
            this.known = this.known.add(key);
            this.nextDefined = true;
            this.next = elem;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.next;
        this.nextDefined = false;
        this.next = null;
        return result;
    }

    @Override
    public String toString() {
        return "DistinctIterator";
    }
}

