/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.Iterator;
import java.util.NoSuchElementException;

final class CachedIterator<T>
implements Iterator<T> {
    private final Iterator<T> that;
    private T next;
    private boolean cached = false;

    CachedIterator(Iterator<T> that) {
        this.that = that;
    }

    @Override
    public boolean hasNext() {
        return this.cached || this.that.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.cached) {
            T result = this.next;
            this.next = null;
            this.cached = false;
            return result;
        }
        return (T)this.that.next();
    }

    T touch() {
        this.next = this.next();
        this.cached = true;
        return this.next;
    }

    @Override
    public String toString() {
        return "CachedIterator";
    }
}

