/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

final class ArrayIterator<T>
implements Iterator<T> {
    private final T[] elements;
    private int index = 0;

    ArrayIterator(T[] elements) {
        this.elements = elements;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.elements.length;
    }

    @Override
    public T next() {
        try {
            return this.elements[this.index++];
        }
        catch (IndexOutOfBoundsException x) {
            --this.index;
            throw new NoSuchElementException();
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        while (this.index < this.elements.length) {
            action.accept(this.elements[this.index++]);
        }
    }

    @Override
    public String toString() {
        return "ArrayIterator";
    }
}

